﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.IO;
using System.Text.RegularExpressions;

namespace FF6Dumper
{
    class Program
    {
        static Random rnd = new Random();
        static int WINDOW_TYPE = 0;
        static int TEXT_TYPE = 1;
        static int POS_TYPE = 2;
        static int menuLineCount = 0;
        static int menuDataFileCount = 0;

        static string[] ff3eStrings = new string[3451];
        
        static string[] fanStrings = new string[3451];
        static string[] fanEnemies = new string[384];
        static string[] fanItems = new string[256];
        static string[] fanEnemyMoves = new string[384];
        static string[] fanMoves = new string[512];
        static string[] fanBattleText = new string[256];
        static string[] fanPlaceNames = new string[512];
        static string[] fanEnemyText = new string[446];
        static string[] fanBattleDialogue = new string[256];

        static string[] gbaStrings = new string[9451];
        static string[] gbaBattleDialogue = new string[512];
        static string[] gbaItemDescriptions = new string[512];
        static string[] gbaEnemyText = new string[446];
        static string[] gbaEnemies = new string[512];

        static string[] ff6Strings = new string[3451];
        static string[] ff6Items = new string[256];
        static string[] ff6ItemDescriptions = new string[256];
        static string[] ff6Enemies = new string[384];
        static string[] ff6EnemyMoves = new string[510];
        static string[] ff6Moves = new string[512];
        static string[] ff6EnemyText = new string[512];
        static string[] ff6BattleText = new string[256];
        static string[] ff6PlaceNames = new string[512];
        static string[] ff6BattleDialogue = new string[512];


        static string[] ff6TEditionStringsBank1 = new string[3451];
        static string[] ff6TEditionStringsBank2 = new string[1262];
        static string[] ff6TBattleDialogue = new string[512];
        static string[] ff6TBattleText = new string[512];
        static string[] ff6TItems = new string[280];
        static string[] ff6TItemDescriptions = new string[280];
        static string[] ff6TEnemyText = new string[256];
        static string[] ff6TEnemies = new string[512];
        static string[] ff6TEnemyMoves = new string[510];
        static string[] ff6TAttackNames = new string[202];
        static string[] ff6TRareItems = new string[30];
        static string[] ff6TPlaceNames = new string[512];
        static string[] ff6TMenuActions = new string[30];
        static string[] ff6TStatusEffects = new string[33];
        static string[] ff6TBlitzDescriptions = new string[8];
        static string[] ff6TBlueMagicDescriptions = new string[24];
        static string[] ff6TBlueMagicNames = new string[32];
        static string[] ff6TDanceNames = new string[8];
        static string[] ff6TEsperAttackDescriptions = new string[27];
        static string[] ff6TEsperAttackNames = new string[28];
        static string[] ff6TEsperNames = new string[28];
        static string[] ff6TJobNames = new string[94];
        static string[] ff6TMagicDescriptions = new string[54];
        static string[] ff6TMagicNames = new string[54];
        static string[] ff6TRageDescriptions = new string[256];
        static string[] ff6TRareItemDescriptions = new string[30];
        static string[] ff6TSwordtechDescriptions = new string[8];
        static string[] ff6TCharacterNames = new string[64];
        static string[] ff6TSongNames = new string[254];


        //static string[] ff6TRageDescriptions = new string[510];

        static string[] exStringsBank1 = new string[3451];
        static string[] exStringsBank2 = new string[1262];
        static string[] exEnemyMoves = new string[510];
        static string[] exAttackNames = new string[202];
        static string[] exEnemies = new string[512];

        static int[] kanjiChangesOnly = { 57,  188, 193, 282, 367, 445, 450, 533, 544, 558, 564, 582, 633, 634, 635, 636, 637, 655, 673, 716, 762, 798, 799, 811, 898, 903, 1129, 1183, 1277, 1285, 1445, 1472, 1545, 1548, 1579, 1659, 1660, 1726, 1728, 1770, 1772, 1773, 1774, 1779, 1871, 1911, 2156, 2420, 2568, 2571, 2625, 2789, 2792, 2796, 2932, };

        static void Main(string[] args)
        {
            //Console.OutputEncoding = System.Text.Encoding.Unicode;
            
            //DumpFF3Text();

            //DumpFF6Text();
            //DumpFF6Items();
            //DumpFF6Enemies();
            //DumpFF6EnemyMoves();
            //DumpFF6Moves();
            //DumpFF6EnemyText();
            //DumpFF6BattleDialogue();
            //DumpFF6BattleText();
            //DumpFF6PlaceNames();
            //DumpFF6ItemDescriptions();

            //DumpFanText();
            //DumpFanEnemies();
            //DumpFanItems();
            //DumpFanEnemyMoves();
            //DumpFanMoves();
            //DumpFanBattleText();
            //DumpFanPlaceNames();
            //DumpFanEnemyText();
            //DumpFanBattleDialogue();
            //DumpFanItemDescriptions();

            //DumpGBAText();

            /*DumpFF6TEditionText("ff6t-ex.smc", "ff6t-ex-bank1-j.txt", "ff6t-ex-bank2-j.txt");
            ff6TEditionStringsBank1.CopyTo(exStringsBank1, 0);
            ff6TEditionStringsBank2.CopyTo(exStringsBank2, 0);
            DumpFF6TEditionText("ff6t.smc", "ff6t-bank1-j.txt", "ff6t-bank2-j.txt");*/

            /*for (int i = 0; i < ff6TEditionStringsBank1.Length; i++)
            {
                if (ff6TEditionStringsBank1[i] != exStringsBank1[i])
                {
                    //Console.WriteLine("Bank 1, Line " + i.ToString() + " changed: " + exStringsBank1[i]);
                    Console.WriteLine(exStringsBank1[i]);
                }
                Console.WriteLine("\n--------------------");
            }*/


            /*for (int i = 0; i < ff6TEditionStringsBank2.Length; i++)
            {
                if (ff6TEditionStringsBank2[i] != exStringsBank2[i])
                {
                    Console.WriteLine(exStringsBank2[i]);
                    //Console.WriteLine("Bank 2, Line " + i.ToString() + " changed: " + exStringsBank2[i]);
                    
                }

                Console.WriteLine("\n--------------------");
            }*/

            //DumpFF6TEnemyText("ff6t-ex.smc");
            //DumpFF6TBattleDialogue("ff6t-ex.smc");

            FindDifferences("ff6t-ex.smc", "ff6t-ex-163.smc", "FF6T-EX", "ex-battle-table.txt");
            //FindDifferences("ff6t.smc", "ff6t-294.smc", "FF6T  ", "ff6t-battle-table.txt");


            
            

            //DumpFF6TEditionMoves(newFilename, "ex-item-table.txt", "ex-battle-table.txt");
            //DumpFF6TEditionMoves(newFilename, "ex-item-table.txt", "ex-battle-table.txt");


            /*ff6TEnemyMoves.CopyTo(exEnemyMoves, 0);
            DumpFF6TEditionEnemyMoves("ff6t.smc", "ff6t-battle-table.txt");*/

            /*string[] exStrings = new string[256];
            string[] ff6TStrings = new string[256];
            DumpFF6TEnemyText("ff6t-ex.smc");
            ff6TEnemyText.CopyTo(exStrings, 0);
            DumpFF6TEnemyText("ff6t.smc");
            ff6TEnemyText.CopyTo(ff6TStrings, 0);






            for (int i = 0; i < ff6TStrings.Length; i++)
            {
                if (ff6TStrings[i] == exStrings[i])
                {
                    Console.WriteLine(ff6TStrings[i]);
                }
                else
                {
                    Console.WriteLine("***" + exStrings[i]);
                }
                Console.WriteLine("--------------------");
            }*/


            // ex battle text
            // ex enemy text

            //DumpFF6TEditionMoves();
            //DumpFF6TPlaceNames();
            //DumpFF6TBattleDialogue();
            //DumpFF6TBattleText();
            //DumpFF6TItems();
            //DumpFF6TEnemyText();
            //DumpFF6TEnemies();
            //DumpFF6TEditionCharacterNames();
            //DumpFF6TEditionRareItems();
            //DumpFF6TEditionRareItemDescriptions();
            //DumpFF6TEditionItemDescriptions();
            //DumpFF6TEditionEsperAttackDescriptions();
            //DumpFF6TEditionMagicDescriptions();
            //DumpFF6TEditionSwordTechDescriptions();
            //DumpFF6TEditionRageDescriptions();
            //DumpFF6TEditionBlitzDescriptions();
            //DumpFF6TEditionBlueMagicDescriptions();
            //DumpFF6TEditionClassNames();
            //DumpFF6TEditionSongNames();
            //DumpFF6TEditionStatusEffects();

            //DumpMenu("ff6t.smc", "ff6t-menu-main.txt", 0x337eb, 0x30000, 38);
            //DumpMenu("ff6t.smc", "ff6t-menu-items.txt", 0x3949a, 0x30000, 3);
            //DumpMenu("ff6t.smc", "ff6t-equip-menu1-j.txt", 0x3ab44, 0x30000, 0xA);
            //DumpMenu("ff6t.smc", "ff6t-equip-menu2-j.txt", 0x3ab60, 0x30000, 0x4);
            //DumpMenu("ff6t.smc", "ff6t-equip-menu3-j.txt", 0x3aab4, 0x30000, 0xA);
            //DumpMenu("ff6t.smc", "ff6t-equip-menu4-j.txt", 0x3a9f8, 0x30000, 0x30);
            //DumpMenu("ff6t.smc", "ff6t-status-menu-j.txt", 0x36a80, 0x30000, 0x30);
            //DumpMenu("ff6t.smc", "ff6t-config-menu1-j.txt", 0x34df5, 0x30000, 0x4);
            //DumpMenu("ff6t.smc", "ff6t-config-menu2-j.txt", 0x34e81, 0x30000, 0x7);
            //DumpMenu("ff6t.smc", "ff6t-config-menu3-j.txt", 0x34ef4, 0x30000, 0x3);
            //DumpMenu("ff6t.smc", "ff6t-config-menu4-j.txt", 0x34f00, 0x30000, 0x6);
            //DumpMenu("ff6t.smc", "ff6t-config-menu5-j.txt", 0x34efa, 0x30000, 0x10);
            /*int[] configTextOffsets = { 0x34e07, 0x34fba, 0x34fc9, 0x34fd4, 0x34fdf, 0x34fea, 0x34ff5, 0x35000, 0x3500b, 0x35016,
                                        0x34e1a, 0x34e22, 0x34e27, 0x34e2c, 0x34e33, 0x34e3a, 0x34e40, 0x34e48, 0x34e4f, 0x34e56, 0x34e5c,
                                        0x34e6a, 0x34f68, 0x34f7a, 0x34f88, 0x34f8f, 0x34f97
                                      };
            DumpMenuFromOffsetList("ff6t.smc", "ff6t-config-menu6-j.txt", configTextOffsets);*/
            //DumpMenu("ff6t.smc", "ff6t-config-menu7-j.txt", 0x35021, 0x30000, 0x50);
            /*int[] configTextOffsets = { 0x394fe, 0x39504, 0x3950c, 0x39513, 0x3951b, 0x3954a, 0x39551, 0x3955b, 0x39562, 0x3956c,
                                        0x39573, 0x3957c, 0x39582, 0x3958a, 0x39591, 0x3959d, 0x395a9, 0x3c535, 0x38eef, 0x38efb,
                                        0x38fde, 0x38fe8, 0x358bb, 0x38f14, 
                                      };
            DumpMenuFromOffsetList("ff6t.smc", "ff6t-item-details-menu-j.txt", configTextOffsets);*/

            /*int[] configTextOffsets = { 0x3d264, 0x3d26b, 0x3d275, 0x3d27e, 0x3d28b, 0x3d290, 0x3d295, 0x3d29f, 0x3d2ab,
                                        0x3d2b7, 0x3d2c2, 0x3d2d8, 0x3d2ee, 0x3d300, 0x3d316, 0x3d327, 0x3d33d, 0x3d351,
                                        0x3d363

                                      };
            DumpMenuFromOffsetList("ff6t.smc", "ff6t-shop-menus1-j.txt", configTextOffsets);*/


            /*int[] configTextOffsets = { 0x3b709, 0x3b711, 0x3bd7c

                                      };
            DumpMenuFromOffsetList("ff6t.smc", "ff6t-coliseum-menus1-j.txt", configTextOffsets);*/

            

            /*for (int y = 0; y < 10; y++)
            {
                string s = "db ";
                int yPos = 0x66 + y * 0xc;
                for (int x = 0; x < 1; x++)
                {
                    //int xPos = 7 + x * 0x48;
                    int xPos = 0;

                    s = s + "$" + xPos.ToString("X2") + ",$" + yPos.ToString("X2") + ",";
                }

                Console.WriteLine(s);
            }*/


            // look for unchanged rage descriptions
            /*string l = "";
            string finalStr = "";
            string[] ff6tTranslatedEnemyMoves = System.IO.File.ReadAllLines("ff6t-enemy-moves-translated.txt");
            string[] ff6tRageDescriptionsJ = System.IO.File.ReadAllLines("ff6t-rage-descriptions-j.txt");
            string[] ff6tEnemyMovesJ = System.IO.File.ReadAllLines("hi.txt");
            for (int i = 0; i < ff6tRageDescriptionsJ.Length; i++)
            {
                l = ff6tRageDescriptionsJ[i];
                for (int j = 0; j < ff6tEnemyMovesJ.Length; j++)
                {
                    if (ff6tRageDescriptionsJ[i] == ff6tEnemyMovesJ[j])
                    {
                        l = ff6tTranslatedEnemyMoves[j];
                        break;
                    }
                }

                Console.WriteLine(l);
                //finalStr += l + "\n";

                //finalStr += l + "\n--------------------\n";
            }
            */


            // look for unchanged item descriptions
            // this turned out to be pointless
            //int sameStrings = 0;
            /*string finalStr = "";
            for (int i = 0; i < ff6TItems.Length; i++)
            {
                string l = "";
                for (int j = 0; j < ff6Items.Length; j++)
                {
                    string ff6tdesc = ff6TItemDescriptions[i];
                    string ff6desc = ff6ItemDescriptions[j];

                    if (ff6TItems[i] == ff6Items[j] && ff6tdesc.Equals(ff6desc))
                    {
                        l = gbaItemDescriptions[j];
                        sameStrings++;
                        break;
                    }
                }

                if (l == "")
                {
                    l = ff6TItemDescriptions[i];
                }

                finalStr += l + "\n--------------------\n";
            }

            Console.WriteLine(finalStr);*/




            // look for unchanged enemy names
            /*int sameStrings = 0;
            string finalStr = "";
            for (int i = 0; i < ff6TEnemies.Length; i++)
            {
                string l = "";
                for (int j = 0; j < ff6Enemies.Length; j++)
                {
                    if (ff6TEnemies[i] == ff6Enemies[j])
                    {
                        l = gbaEnemies[j];
                        sameStrings++;
                        break;
                    }
                }

                if (l == "")
                {
                    l = ff6TEnemies[i];
                }

                finalStr += l + "\n"; // +"\n--------------------\n";
            }

            Console.WriteLine(finalStr);*/

            // look for unchanged enemy text strings
            /*int sameStrings = 0;
            string finalStr = "";
            for (int i = 0; i < ff6TEnemyText.Length; i++)
            {
                string l = "";
                if (ff6EnemyText[i] == ff6TEnemyText[i])
                {
                    l = gbaEnemyText[i];
                    sameStrings++;
                }
                else
                {
                    l = "***" + ff6TEnemyText[i];
                }

                finalStr += l + "\n--------------------\n";
            }

            Console.WriteLine(finalStr);*/


            // look for unchanged battle dialogue strings
            /*int sameStrings = 0;
            string finalStr = "";
            // See what Japanese lines didn't change in the jump to T-Edition
            // If any lines are the same, we'll copy the corresponding official English line
            // Otherwise we'll copy the latest T-Edition line
            for (int i = 0; i < ff6TBattleDialogue.Length; i++)
            {
                string l = "";
                if (ff6BattleDialogue[i] == ff6TBattleDialogue[i])
                {
                    l = gbaBattleDialogue[i];
                    sameStrings++;
                }
                else
                {
                    l = "***" + ff6TBattleDialogue[i];
                }

                finalStr += l + "\n";
            }

            Console.WriteLine(finalStr);*/



            /*
             // look for unchanged main script strings
            int sameStrings = 0;
            int sameStringsWithDiffKanji = 0;
            string finalStr = "";
            // See what Japanese lines didn't change in the jump to T-Edition
            // If any lines are the same, we'll copy the corresponding official English line
            // Otherwise we'll copy the latest T-Edition line
            for (int i = 0; i < ff6TEditionStringsBank1.Length; i++)
            {
                if (i == 3044)
                {
                    int p = 33;
                }

                string ff6fart = ff6Strings[i];
                string ff6tfart = ff6TEditionStringsBank1[i];

                string l = "";
                if (ff6Strings[i] == ff6TEditionStringsBank1[i])
                {
                    l = gbaStrings[i]; // ff3eStrings[i];
                    sameStrings++;
                }
                else
                {
                    //Console.WriteLine("<div style=\"margin-bottom:30px;border-bottom:1px solid black;margin-top:30px;\">");
                    //Console.WriteLine("<h4>Line " + i.ToString() + "</h4>");
                    //Console.WriteLine("<div style=\"background:#EEEEEE;float:left;\">" + ff6Strings[i] + "</div>");
                    //Console.WriteLine("<div style=\"background:#DDDDDD;float:left;\">" + ff6TEditionStrings[i] + "</div>");
                    //Console.WriteLine("<div style=\"clear:both;\"></div>");
                    //Console.WriteLine("</div>");

                    // Some FF6T lines are basically the same as the original lines, only with some kanji added
                    // We don't need to change any translations in these instances, so we check a pre-made list of line #s
                    // and if the line # is specifically listed, it means the change can be ignored and we can use the
                    // original English translation. Otherwise we assume that the line was changed and needs retranslation,
                    // so we'll output the FF6T Japanese line instead.
                    if (kanjiChangesOnly.Contains(i))
                    {
                        l = gbaStrings[i];//  3eStrings[i];
                        sameStringsWithDiffKanji++;
                    }
                    else
                    {
                        l = "***" + ff6TEditionStringsBank1[i];
                    }
                    
                }

                //string finalLine = i.ToString() + "\n" + l + "\n";
                string finalLine = l;


                finalStr += finalLine + "\n";
                //Console.WriteLine(finalLine);
            }

            System.IO.File.WriteAllText("ff6t-translation-bank1.txt", finalStr);

            // We're going to check the new T-Edition Bank 2 to see if any of it is actually Bank 1 text
            // from the original Japanese script, if so, we'll copy the corresponding official English line
            // Otherwise we'll copy the latest T-Edition line
            finalStr = "";
            for (int i = 0; i < ff6TEditionStringsBank2.Length; i++)
            {
                string l = "";

                l = ff6TEditionStringsBank2[i];
                for (int j = 0; j < ff6Strings.Length; j++)
                {
                    if (ff6TEditionStringsBank2[i] == ff6Strings[j])
                    {
                        //l = ff3eStrings[j];
                        l = gbaStrings[j];
                        sameStrings++;
                        break;
                    }
                }

                string finalLine = l + "\n";


                //Console.WriteLine(finalLine);
                finalStr += finalLine;
            }

            System.IO.File.WriteAllText("ff6t-translation-bank2.txt", finalStr);

            int totalFF6TStrings = ff6TEditionStringsBank1.Length + ff6TEditionStringsBank2.Length;
            int totalCopiedStrings = sameStrings + sameStringsWithDiffKanji;
            float percent = ((float)totalCopiedStrings / (float)totalFF6TStrings) * 100.0f;
            Console.WriteLine("Unchanged Strings:\t\t\t" + sameStrings.ToString());
            Console.WriteLine("Unchanged Strings w/ Kanji Updates:\t" + sameStringsWithDiffKanji.ToString());
            Console.WriteLine("\nTotal GBA Strings Copied Over: " + totalCopiedStrings.ToString() + "/" + totalFF6TStrings.ToString() + " (" + percent.ToString(".0#") + "%)");
             * */

            //Console.ReadKey();
        }


        static void FindDifferences(string oldFilename, string newFilename, string comparisonType, string battleTableFilename)
        {
            // EX ATTACK NAMES
            int strCount = ff6TAttackNames.Length;
            string fullComparisonType = comparisonType + " Attack Name";
            string[] oldStrings = new string[ff6TAttackNames.Length];
            string[] newStrings = new string[ff6TAttackNames.Length];
            DumpFF6TEditionAttackNames(newFilename, battleTableFilename);
            ff6TAttackNames.CopyTo(newStrings, 0);
            DumpFF6TEditionAttackNames(oldFilename, battleTableFilename);
            ff6TAttackNames.CopyTo(oldStrings, 0);
            CompareOldAndNewStrings(oldStrings, newStrings, fullComparisonType);

            // EX BATTLE DIALOGUE
            strCount = ff6TBattleDialogue.Length;
            fullComparisonType = comparisonType + " Battle Dialog";
            oldStrings = new string[strCount];
            newStrings = new string[strCount];
            DumpFF6TBattleDialogue(newFilename);
            ff6TBattleDialogue.CopyTo(newStrings, 0);
            DumpFF6TBattleDialogue(oldFilename);
            ff6TBattleDialogue.CopyTo(oldStrings, 0);
            CompareOldAndNewStrings(oldStrings, newStrings, fullComparisonType);

            // MENU ACTIONS
            strCount = ff6TMenuActions.Length;
            fullComparisonType = comparisonType + " Menu Action";
            oldStrings = new string[strCount];
            newStrings = new string[strCount];
            DumpFF6TMenuActions(newFilename, battleTableFilename);
            ff6TMenuActions.CopyTo(newStrings, 0);
            DumpFF6TMenuActions(oldFilename, battleTableFilename);
            ff6TMenuActions.CopyTo(oldStrings, 0);
            CompareOldAndNewStrings(oldStrings, newStrings, fullComparisonType);

            // STATUS EFFECTS
            strCount = ff6TStatusEffects.Length;
            fullComparisonType = comparisonType + " Status Effect";
            oldStrings = new string[strCount];
            newStrings = new string[strCount];
            DumpFF6TEditionStatusEffects(newFilename);
            ff6TStatusEffects.CopyTo(newStrings, 0);
            DumpFF6TEditionStatusEffects(oldFilename);
            ff6TStatusEffects.CopyTo(oldStrings, 0);
            CompareOldAndNewStrings(oldStrings, newStrings, fullComparisonType);

            // BATTLE TEXT
            strCount = ff6TBattleText.Length;
            fullComparisonType = comparisonType + " Battle Text";
            oldStrings = new string[strCount];
            newStrings = new string[strCount];
            DumpFF6TBattleText(newFilename);
            ff6TBattleText.CopyTo(newStrings, 0);
            DumpFF6TBattleText(oldFilename);
            ff6TBattleText.CopyTo(oldStrings, 0);
            CompareOldAndNewStrings(oldStrings, newStrings, fullComparisonType);

            // BLITZ DESCRIPTIONS
            strCount = ff6TBlitzDescriptions.Length;
            fullComparisonType = comparisonType + " Blitz Desc";
            oldStrings = new string[strCount];
            newStrings = new string[strCount];
            DumpFF6TEditionBlitzDescriptions(newFilename);
            ff6TBlitzDescriptions.CopyTo(newStrings, 0);
            DumpFF6TEditionBlitzDescriptions(oldFilename);
            ff6TBlitzDescriptions.CopyTo(oldStrings, 0);
            CompareOldAndNewStrings(oldStrings, newStrings, fullComparisonType);

            // BLUE MAGIC DESCRIPTIONS
            strCount = ff6TBlueMagicDescriptions.Length;
            fullComparisonType = comparisonType + " Blue Mag Desc";
            oldStrings = new string[strCount];
            newStrings = new string[strCount];
            DumpFF6TEditionBlueMagicDescriptions(newFilename);
            ff6TBlueMagicDescriptions.CopyTo(newStrings, 0);
            DumpFF6TEditionBlueMagicDescriptions(oldFilename);
            ff6TBlueMagicDescriptions.CopyTo(oldStrings, 0);
            CompareOldAndNewStrings(oldStrings, newStrings, fullComparisonType);

            // BLUE MAGIC NAMES
            strCount = ff6TBlueMagicNames.Length;
            fullComparisonType = comparisonType + " Blue Mag Name";
            oldStrings = new string[strCount];
            newStrings = new string[strCount];
            DumpFF6TEditionBlueMagicNames(newFilename, battleTableFilename);
            ff6TBlueMagicNames.CopyTo(newStrings, 0);
            DumpFF6TEditionBlueMagicNames(oldFilename, battleTableFilename);
            ff6TBlueMagicNames.CopyTo(oldStrings, 0);
            CompareOldAndNewStrings(oldStrings, newStrings, fullComparisonType);

            // CHARACTER NAMES
            strCount = ff6TCharacterNames.Length;
            fullComparisonType = comparisonType + " Character Name";
            oldStrings = new string[strCount];
            newStrings = new string[strCount];
            DumpFF6TEditionCharacterNames(newFilename);
            ff6TCharacterNames.CopyTo(newStrings, 0);
            DumpFF6TEditionCharacterNames(oldFilename);
            ff6TCharacterNames.CopyTo(oldStrings, 0);
            CompareOldAndNewStrings(oldStrings, newStrings, fullComparisonType);

            // DANCE NAMES
            strCount = ff6TDanceNames.Length;
            fullComparisonType = comparisonType + " Dance Name";
            oldStrings = new string[strCount];
            newStrings = new string[strCount];
            DumpFF6TEditionDanceNames(newFilename, battleTableFilename);
            ff6TDanceNames.CopyTo(newStrings, 0);
            DumpFF6TEditionDanceNames(oldFilename, battleTableFilename);
            ff6TDanceNames.CopyTo(oldStrings, 0);
            CompareOldAndNewStrings(oldStrings, newStrings, fullComparisonType);

            // ENEMY MOVES
            int startLoc = 0x5f4500;
            if (comparisonType == "FF6T-EX")
            {
                startLoc = 0x2a5000;
            }
            strCount = ff6TEnemyMoves.Length;
            fullComparisonType = comparisonType + " Enemy Move";
            oldStrings = new string[strCount];
            newStrings = new string[strCount];
            DumpFF6TEditionEnemyMoves(newFilename, battleTableFilename, startLoc);
            ff6TEnemyMoves.CopyTo(newStrings, 0);
            DumpFF6TEditionEnemyMoves(oldFilename, battleTableFilename, startLoc);
            ff6TEnemyMoves.CopyTo(oldStrings, 0);
            CompareOldAndNewStrings(oldStrings, newStrings, fullComparisonType);

            // ENEMY NAMES
            strCount = ff6TEnemies.Length;
            fullComparisonType = comparisonType + " Enemy Name";
            oldStrings = new string[strCount];
            newStrings = new string[strCount];
            DumpFF6TEnemies(newFilename);
            ff6TEnemies.CopyTo(newStrings, 0);
            DumpFF6TEnemies(oldFilename);
            ff6TEnemies.CopyTo(oldStrings, 0);
            CompareOldAndNewStrings(oldStrings, newStrings, fullComparisonType);

            // ENEMY TEXT
            strCount = ff6TEnemyText.Length;
            fullComparisonType = comparisonType + " Enemy Text";
            oldStrings = new string[strCount];
            newStrings = new string[strCount];
            DumpFF6TEnemyText(newFilename, battleTableFilename);
            ff6TEnemyText.CopyTo(newStrings, 0);
            DumpFF6TEnemyText(oldFilename, battleTableFilename);
            ff6TEnemyText.CopyTo(oldStrings, 0);
            CompareOldAndNewStrings(oldStrings, newStrings, fullComparisonType);

            // ESPER ATTACK DESCRIPTIONS
            strCount = ff6TEsperAttackDescriptions.Length;
            fullComparisonType = comparisonType + " Esper Atk Desc";
            oldStrings = new string[strCount];
            newStrings = new string[strCount];
            DumpFF6TEditionEsperAttackDescriptions(newFilename);
            ff6TEsperAttackDescriptions.CopyTo(newStrings, 0);
            DumpFF6TEditionEsperAttackDescriptions(oldFilename);
            ff6TEsperAttackDescriptions.CopyTo(oldStrings, 0);
            CompareOldAndNewStrings(oldStrings, newStrings, fullComparisonType);

            // ESPER ATTACK NAMES
            strCount = ff6TEsperAttackNames.Length;
            fullComparisonType = comparisonType + " Esper Atk Name";
            oldStrings = new string[strCount];
            newStrings = new string[strCount];
            DumpFF6TEsperAttackNames(newFilename, battleTableFilename);
            ff6TEsperAttackNames.CopyTo(newStrings, 0);
            DumpFF6TEsperAttackNames(oldFilename, battleTableFilename);
            ff6TEsperAttackNames.CopyTo(oldStrings, 0);
            CompareOldAndNewStrings(oldStrings, newStrings, fullComparisonType);

            // ESPER NAMES
            strCount = ff6TEsperNames.Length;
            fullComparisonType = comparisonType + " Esper Name";
            oldStrings = new string[strCount];
            newStrings = new string[strCount];
            DumpFF6TEsperNames(newFilename, battleTableFilename);
            ff6TEsperNames.CopyTo(newStrings, 0);
            DumpFF6TEsperNames(oldFilename, battleTableFilename);
            ff6TEsperNames.CopyTo(oldStrings, 0);
            CompareOldAndNewStrings(oldStrings, newStrings, fullComparisonType);

            // ITEM DESCRIPTIONS
            strCount = ff6TItemDescriptions.Length;
            fullComparisonType = comparisonType + " Item Desc";
            oldStrings = new string[strCount];
            newStrings = new string[strCount];
            DumpFF6TEditionItemDescriptions(newFilename);
            ff6TItemDescriptions.CopyTo(newStrings, 0);
            DumpFF6TEditionItemDescriptions(oldFilename);
            ff6TItemDescriptions.CopyTo(oldStrings, 0);
            CompareOldAndNewStrings(oldStrings, newStrings, fullComparisonType);

            // ITEM DESCRIPTIONS
            strCount = ff6TItems.Length;
            fullComparisonType = comparisonType + " Item Name";
            oldStrings = new string[strCount];
            newStrings = new string[strCount];
            DumpFF6TItems(newFilename);
            ff6TItems.CopyTo(newStrings, 0);
            DumpFF6TItems(oldFilename);
            ff6TItems.CopyTo(oldStrings, 0);
            CompareOldAndNewStrings(oldStrings, newStrings, fullComparisonType);

            // JOB NAMES
            strCount = ff6TJobNames.Length;
            fullComparisonType = comparisonType + " Job Name";
            oldStrings = new string[strCount];
            newStrings = new string[strCount];
            DumpFF6TEditionJobNames(newFilename);
            ff6TJobNames.CopyTo(newStrings, 0);
            DumpFF6TEditionJobNames(oldFilename);
            ff6TJobNames.CopyTo(oldStrings, 0);
            CompareOldAndNewStrings(oldStrings, newStrings, fullComparisonType);

            // MAGIC DESCRIPTIONS
            strCount = ff6TMagicDescriptions.Length;
            fullComparisonType = comparisonType + " Magic Desc";
            oldStrings = new string[strCount];
            newStrings = new string[strCount];
            DumpFF6TEditionMagicDescriptions(newFilename);
            ff6TMagicDescriptions.CopyTo(newStrings, 0);
            DumpFF6TEditionMagicDescriptions(oldFilename);
            ff6TMagicDescriptions.CopyTo(oldStrings, 0);
            CompareOldAndNewStrings(oldStrings, newStrings, fullComparisonType);

            // MAGIC NAMES
            strCount = ff6TMagicNames.Length;
            fullComparisonType = comparisonType + " Magic Name";
            oldStrings = new string[strCount];
            newStrings = new string[strCount];
            DumpFF6TMagicNames(newFilename, battleTableFilename);
            ff6TMagicNames.CopyTo(newStrings, 0);
            DumpFF6TMagicNames(oldFilename, battleTableFilename);
            ff6TMagicNames.CopyTo(oldStrings, 0);
            CompareOldAndNewStrings(oldStrings, newStrings, fullComparisonType);

            // PLACE NAMES
            strCount = ff6TPlaceNames.Length;
            fullComparisonType = comparisonType + " Place Name";
            oldStrings = new string[strCount];
            newStrings = new string[strCount];
            DumpFF6TPlaceNames(newFilename, 0x268400, 0x58ea00);
            ff6TPlaceNames.CopyTo(newStrings, 0);
            DumpFF6TPlaceNames(oldFilename, 0x268400, 0x58ea00 );
            ff6TPlaceNames.CopyTo(oldStrings, 0);
            CompareOldAndNewStrings(oldStrings, newStrings, fullComparisonType);

            // RAGE DESCRIPTIONS
            strCount = ff6TRageDescriptions.Length;
            fullComparisonType = comparisonType + " Rage Desc";
            oldStrings = new string[strCount];
            newStrings = new string[strCount];
            DumpFF6TEditionRageDescriptions(newFilename);
            ff6TRageDescriptions.CopyTo(newStrings, 0);
            DumpFF6TEditionRageDescriptions(oldFilename);
            ff6TRageDescriptions.CopyTo(oldStrings, 0);
            CompareOldAndNewStrings(oldStrings, newStrings, fullComparisonType);

            // RARE ITEM DESCRIPTIONS
            strCount = ff6TRareItemDescriptions.Length;
            fullComparisonType = comparisonType + " Rare Item Desc";
            oldStrings = new string[strCount];
            newStrings = new string[strCount];
            DumpFF6TEditionRareItemDescriptions(newFilename);
            ff6TRareItemDescriptions.CopyTo(newStrings, 0);
            DumpFF6TEditionRareItemDescriptions(oldFilename);
            ff6TRareItemDescriptions.CopyTo(oldStrings, 0);
            CompareOldAndNewStrings(oldStrings, newStrings, fullComparisonType);

            // RARE ITEM NAMES
            strCount = ff6TRareItems.Length;
            fullComparisonType = comparisonType + " Rare Item Name";
            oldStrings = new string[strCount];
            newStrings = new string[strCount];
            DumpFF6TEditionRareItems(newFilename);
            ff6TRareItems.CopyTo(newStrings, 0);
            DumpFF6TEditionRareItems(oldFilename);
            ff6TRareItems.CopyTo(oldStrings, 0);
            CompareOldAndNewStrings(oldStrings, newStrings, fullComparisonType);

            // SWORDTECH DESCRIPTIONS
            strCount = ff6TSwordtechDescriptions.Length;
            fullComparisonType = comparisonType + " Swdtech Desc";
            oldStrings = new string[strCount];
            newStrings = new string[strCount];
            DumpFF6TEditionSwordTechDescriptions(newFilename);
            ff6TSwordtechDescriptions.CopyTo(newStrings, 0);
            DumpFF6TEditionSwordTechDescriptions(oldFilename);
            ff6TSwordtechDescriptions.CopyTo(oldStrings, 0);
            CompareOldAndNewStrings(oldStrings, newStrings, fullComparisonType);

            // SWORDTECH NAMES
            // These names are stored in a non-standard way in the Japanese game, so we'll skip this check here
            // It's unlikely any will get added/changed anyway

            // MUSIC PLAYER SONG NAMES
            strCount = ff6TSongNames.Length;
            fullComparisonType = comparisonType + " Song Name";
            oldStrings = new string[strCount];
            newStrings = new string[strCount];
            DumpFF6TEditionSongNames(newFilename);
            ff6TSongNames.CopyTo(newStrings, 0);
            DumpFF6TEditionSongNames(oldFilename);
            ff6TSongNames.CopyTo(oldStrings, 0);
            CompareOldAndNewStrings(oldStrings, newStrings, fullComparisonType);


            // MAIN SCRIPT BANK 1 TEXT
            strCount = ff6TEditionStringsBank1.Length;
            fullComparisonType = comparisonType + " Script Bank 1";
            oldStrings = new string[strCount];
            newStrings = new string[strCount];
            DumpFF6TEditionText(newFilename, newFilename + "-bank1-j.txt", newFilename + "-bank2-j.txt");
            ff6TEditionStringsBank1.CopyTo(newStrings, 0);
            DumpFF6TEditionText(oldFilename, oldFilename + "-bank1-j.txt", oldFilename + "-bank2-j.txt");
            ff6TEditionStringsBank1.CopyTo(oldStrings, 0);
            CompareOldAndNewStrings(oldStrings, newStrings, fullComparisonType);

            // MAIN SCRIPT BANK 2 TEXT
            strCount = ff6TEditionStringsBank2.Length;
            fullComparisonType = comparisonType + " Script Bank 2";
            oldStrings = new string[strCount];
            newStrings = new string[strCount];
            DumpFF6TEditionText(newFilename, newFilename + "-bank1-j.txt", newFilename + "-bank2-j.txt");
            ff6TEditionStringsBank2.CopyTo(newStrings, 0);
            DumpFF6TEditionText(oldFilename, oldFilename + "-bank1-j.txt", oldFilename + "-bank2-j.txt");
            ff6TEditionStringsBank2.CopyTo(oldStrings, 0);
            CompareOldAndNewStrings(oldStrings, newStrings, fullComparisonType);


        }

        static void CompareOldAndNewStrings(string[] oldStrings, string[] newStrings, string comparisonType)
        {
            int problemTotal = 0;
            for (int i = 0; i < newStrings.Length; i++)
            {
                if (newStrings[i] != oldStrings[i])
                {
                    if (problemTotal == 0)
                    {
                        Console.WriteLine(comparisonType + " strings:\t CHANGES FOUND!!!");
                    }

                    Console.WriteLine("\t" + newStrings[i]);
                    problemTotal++;
                }
            }

            if (problemTotal == 0)
            {
                Console.WriteLine(comparisonType + " strings:\t NO CHANGE");
            }
            
        }




        static void DumpMenu(string romName, string outputFileName, int offsetTableStart, int textDataStart, int totalEntries)
        {
            FF6TableReader_Item table = new FF6TableReader_Item("ff6t-menu-table.txt");
            FileStream romFile = new FileStream(romName, FileMode.Open);
            string[] menuEntries = new string[totalEntries];

            for (int i = 0; i < totalEntries; i++)
            {
                romFile.Seek(offsetTableStart + i * 2, SeekOrigin.Begin);
                int offset = romFile.ReadByte() | (romFile.ReadByte() << 8);
                
                int bank = (offsetTableStart >> 16) << 16;
                romFile.Seek(bank + offset, SeekOrigin.Begin);
                int rewriteOffsetLoc = bank + offset;
                //int  = romFile.ReadByte() | (romFile.ReadByte() << 8) | bank;

                int textStartLoc = textDataStart + offset;
                romFile.Seek(textDataStart + offset, SeekOrigin.Begin);
                byte b0 = (byte)romFile.ReadByte();
                byte b1 = (byte)romFile.ReadByte();

                string text = table.GetLine(romFile, textStartLoc + 2, 5000, true);

                menuEntries[i] = rewriteOffsetLoc.ToString("X6") + "|[" + b0.ToString("X2") + "][" + b1.ToString("X2") + "]" + text;
            }

            File.WriteAllLines(outputFileName, menuEntries, Encoding.UTF8);
            romFile.Close();
        }


        static void DumpMenuFromOffsetList(string romName, string outputFileName, int[] offsets)
        {
            FF6TableReader_Item table = new FF6TableReader_Item("ff6t-menu-table.txt");
            FileStream romFile = new FileStream(romName, FileMode.Open);
            string[] menuEntries = new string[offsets.Length];

            for (int i = 0; i < offsets.Length; i++)
            {
                romFile.Seek(offsets[i], SeekOrigin.Begin);

                byte b0 = (byte)romFile.ReadByte();
                byte b1 = (byte)romFile.ReadByte();

                string text = table.GetLine(romFile, offsets[i] + 2, 5000, true);

                menuEntries[i] = offsets[i].ToString("X6") + "|[" + b0.ToString("X2") + "][" + b1.ToString("X2") + "]" + text;
            }

            File.WriteAllLines(outputFileName, menuEntries, Encoding.UTF8);
            romFile.Close();
        }



        static void DumpFF3Text()
        {
            string romName = "ff3.smc";
            FF3TableReader_Script ff3ScriptTable = new FF3TableReader_Script("english-script-table.txt");
            Console.OutputEncoding = System.Text.Encoding.UTF8;
            FileStream romFile = new FileStream(romName, FileMode.Open);

            // The 16-bit number here tells the game when to jump to a new text bank if a line ID is >= to it
            romFile.Seek(0xCE600, SeekOrigin.Begin);
            int newBankID = romFile.ReadByte() | (romFile.ReadByte() << 8);

            for (int j = 0; j < 3084; j++)
            {
                int loc = 0xCE602 + j * 2;
                romFile.Seek(loc, SeekOrigin.Begin);
                int offset = romFile.ReadByte() | (romFile.ReadByte() << 8);
                string line = "";

                // offset FFFF indicates the line doesn't exist
                if (offset != 0xFFFF)
                {
                    int lineStart = 0xD0000 + offset;
                    if (j >= newBankID)
                    {
                        lineStart += 0x10000;
                    }
                    line = ff3ScriptTable.GetLine(romFile, lineStart);
                }

                ff3eStrings[j] = line;

                /*if (ff3ScriptTable.convertToHTML)
                {
                    Console.WriteLine("<div id=\"script-" + j.ToString() + "\">" + line + "</div>");
                }
                else
                {
                    Console.WriteLine(line);
                }*/
            }

            romFile.Close();
        }



        static void DumpFanText()
        {
            string romName = "ff6skyrenderv1.smc"; // "ff6skyrender.smc";
            FanTableReader_Script ff3ScriptTable = new FanTableReader_Script("fan-script-table.txt");
            Console.OutputEncoding = System.Text.Encoding.UTF8;
            FileStream romFile = new FileStream(romName, FileMode.Open);

            // DUMP NAMES
            /*for (int i = 0; i < 128; i++)
            {
                int l = 0x306000 + i * 6;
                string s = ff3ScriptTable.GetLine(romFile, l, 6);
                Console.WriteLine(i.ToString() + ":\t" + s);
            }*/

            // The 16-bit number here tells the game when to jump to a new text bank if a line ID is >= to it
            //romFile.Seek(0xCE600, SeekOrigin.Begin);
            //int newBankID = romFile.ReadByte() | (romFile.ReadByte() << 8);

            for (int j = 0; j < 3084; j++)
            {
                int loc = 0xCE602 + j * 2;
                romFile.Seek(loc, SeekOrigin.Begin);
                int offset = romFile.ReadByte() | (romFile.ReadByte() << 8);
                string line = "";

                // offset FFFF indicates the line doesn't exist
                if (offset != 0xFFFF)
                {
                    int lineStart = offset;
                    //int lineStart = 0xD0000 + offset;

                    if (j < 0x28F)
                    {
                        lineStart += 0x320000;
                    }
                    else if (j < 0x5F5)
                    {
                        lineStart += 0x330000;
                    }
                    else if (j < 0x8EE)
                    {
                        lineStart += 0x340000;
                    }
                    else
                    {
                        lineStart += 0x350000;
                    }

                    
                    line = ff3ScriptTable.GetLine(romFile, lineStart);
                }

                fanStrings[j] = line;

                if (ff3ScriptTable.convertToHTML)
                {
                    Console.WriteLine("<div id=\"fan-script-" + j.ToString() + "\">" + line + "</div>");
                }
                else
                {
                    Console.WriteLine(line);
                }
            }

            romFile.Close();
        }


        static void DumpFanEnemies()
        {
            string romName = "ff6skyrender.smc";
            FanTableReader_Script ff6ItemTable = new FanTableReader_Script("fan-script-table.txt");
            Console.OutputEncoding = System.Text.Encoding.UTF8;
            FileStream romFile = new FileStream(romName, FileMode.Open);

            for (int j = 0; j < 384; j++)
            {
                int loc = 0x303A00 + j * 2;
                romFile.Seek(loc, SeekOrigin.Begin);
                int offset = romFile.ReadByte() | (romFile.ReadByte() << 8);

                loc = 0x300000 + offset;
                string line = "";

                line = ff6ItemTable.GetLine(romFile, loc, 5000);

                fanEnemies[j] = line;

                if (ff6ItemTable.convertToHTML)
                {
                    Console.WriteLine("<div id=\"fan-enemy-" + j.ToString() + "\">" + line + "</div>");
                }
                else
                {
                    Console.WriteLine(line);
                }
            }

            romFile.Close();
        }

        static void DumpFanItems()
        {
            string romName = "ff6skyrender.smc";
            FanTableReader_Script ff6ItemTable = new FanTableReader_Script("fan-item-table.txt");
            Console.OutputEncoding = System.Text.Encoding.UTF8;
            FileStream romFile = new FileStream(romName, FileMode.Open);

            for (int j = 0; j < 256; j++)
            {
                int loc = 0x313000 + j * 2;
                romFile.Seek(loc, SeekOrigin.Begin);
                int offset = romFile.ReadByte() | (romFile.ReadByte() << 8);

                loc = 0x310000 + offset;
                string line = "";

                line = ff6ItemTable.GetLine(romFile, loc, 5000);

                fanItems[j] = line;

                if (ff6ItemTable.convertToHTML)
                {
                    Console.WriteLine("<div id=\"fan-item-" + j.ToString() + "\">" + line + "</div>");
                }
                else
                {
                    Console.WriteLine(line);
                }
            }

            romFile.Close();
        }

        static void DumpFanEnemyMoves()
        {
            string romName = "ff6skyrender.smc";
            FanTableReader_Script ff6ItemTable = new FanTableReader_Script("fan-item-table.txt");
            Console.OutputEncoding = System.Text.Encoding.UTF8;
            FileStream romFile = new FileStream(romName, FileMode.Open);

            for (int j = 0; j < 384; j++)
            {
                int loc = 0x303d00 + j * 2;
                romFile.Seek(loc, SeekOrigin.Begin);
                int offset = romFile.ReadByte() | (romFile.ReadByte() << 8);

                loc = 0x300000 + offset;
                string line = "";

                line = ff6ItemTable.GetLine(romFile, loc, 5000);

                fanEnemyMoves[j] = line;

                if (ff6ItemTable.convertToHTML)
                {
                    Console.WriteLine("<div id=\"fan-enemymove-" + j.ToString() + "\">" + line + "</div>");
                }
                else
                {
                    Console.WriteLine(line);
                }
            }

            romFile.Close();
        }

        static void DumpFanMoves()
        {
            string romName = "ff6skyrender.smc";
            FanTableReader_Script ff6ItemTable = new FanTableReader_Script("fan-item-table.txt");
            Console.OutputEncoding = System.Text.Encoding.UTF8;
            FileStream romFile = new FileStream(romName, FileMode.Open);

            int index = 0;

            // Spells
            for (int j = 0; j < 54; j++)
            {
                int loc = 0x300d00 + j * 2;
                romFile.Seek(loc, SeekOrigin.Begin);
                int offset = romFile.ReadByte() | (romFile.ReadByte() << 8);

                loc = 0x300000 + offset;
                string line = "";

                line = ff6ItemTable.GetLine(romFile, loc, 5000);

                fanMoves[index] = line;

                if (ff6ItemTable.convertToHTML)
                {
                    Console.WriteLine("<div id=\"fan-move-" + index.ToString() + "\">" + line + "</div>");
                }
                else
                {
                    Console.WriteLine(line);
                }

                index++;
            }

            // Espers
            for (int j = 54; j < 81; j++)
            {
                int loc = 0x300d00 + (j + 10) * 2;
                romFile.Seek(loc, SeekOrigin.Begin);
                int offset = romFile.ReadByte() | (romFile.ReadByte() << 8);

                loc = 0x300000 + offset;
                string line = "";

                line = ff6ItemTable.GetLine(romFile, loc, 5000);

                fanMoves[index] = line;

                if (ff6ItemTable.convertToHTML)
                {
                    Console.WriteLine("<div id=\"fan-move-" + index.ToString() + "\">" + line + "</div>");
                }
                else
                {
                    Console.WriteLine(line);
                }

                index++;
            }
            
            // Ninja attacks
            for (int j = 86; j < 91; j++)
            {
                int loc = 0x300d00 + (j + 10) * 2;
                romFile.Seek(loc, SeekOrigin.Begin);
                int offset = romFile.ReadByte() | (romFile.ReadByte() << 8);

                loc = 0x300000 + offset;
                string line = "";

                line = ff6ItemTable.GetLine(romFile, loc, 5000);

                fanMoves[index] = line;

                if (ff6ItemTable.convertToHTML)
                {
                    Console.WriteLine("<div id=\"fan-move-" + index.ToString() + "\">" + line + "</div>");
                }
                else
                {
                    Console.WriteLine(line);
                }

                index++;
            }

            for (int j = 86; j < 93; j++)
            {
                string line = "";
                if (ff6ItemTable.convertToHTML)
                {
                    Console.WriteLine("<div id=\"fan-move-" + index.ToString() + "\">" + line + "</div>");
                }
                else
                {
                    Console.WriteLine(line);
                }

                index++;
            }

            // Ninja attacks
            for (int j = 94; j < 384; j++)
            {
                int loc = 0x300d00 + (j + 7) * 2;
                romFile.Seek(loc, SeekOrigin.Begin);
                int offset = romFile.ReadByte() | (romFile.ReadByte() << 8);

                loc = 0x300000 + offset;
                string line = "";

                line = ff6ItemTable.GetLine(romFile, loc, 5000);

                fanMoves[index] = line;

                if (ff6ItemTable.convertToHTML)
                {
                    Console.WriteLine("<div id=\"fan-move-" + index.ToString() + "\">" + line + "</div>");
                }
                else
                {
                    Console.WriteLine(line);
                }

                index++;
            }

            // I wound up adding the swordtechs manually in almost every instance
            romFile.Close();
        }


        static void DumpFanBattleText()
        {
            string romName = "ff6skyrender.smc";
            FanTableReader_Script ff6ItemTable = new FanTableReader_Script("fan-item-table.txt");
            Console.OutputEncoding = System.Text.Encoding.UTF8;
            FileStream romFile = new FileStream(romName, FileMode.Open);

            for (int j = 0; j < 256; j++)
            {
                int loc = 0x305000 + j * 2;
                romFile.Seek(loc, SeekOrigin.Begin);
                int offset = romFile.ReadByte() | (romFile.ReadByte() << 8);

                loc = 0x300000 + offset;
                string line = "";

                line = ff6ItemTable.GetLine(romFile, loc, 5000);

                fanBattleText[j] = line;

                if (ff6ItemTable.convertToHTML)
                {
                    Console.WriteLine("<div id=\"fan-battletext-" + j.ToString() + "\">" + line + "</div>");
                }
                else
                {
                    Console.WriteLine(line);
                }
            }

            romFile.Close();
        }


        static void DumpFanPlaceNames()
        {
            string romName = "ff6skyrender.smc";
            FanTableReader_Script ff6ItemTable = new FanTableReader_Script("fan-item-table.txt");
            Console.OutputEncoding = System.Text.Encoding.UTF8;
            FileStream romFile = new FileStream(romName, FileMode.Open);

            for (int j = 0; j < 512; j++)
            {
                int loc = 0x305A00 + j * 2;
                romFile.Seek(loc, SeekOrigin.Begin);
                int offset = romFile.ReadByte() | (romFile.ReadByte() << 8);

                loc = 0x300000 + offset;
                string line = "";

                line = ff6ItemTable.GetLine(romFile, loc, 5000);

                fanPlaceNames[j] = line;

                if (ff6ItemTable.convertToHTML)
                {
                    Console.WriteLine("<div id=\"fan-placename-" + j.ToString() + "\">" + line + "</div>");
                }
                else
                {
                    Console.WriteLine(line);
                }
            }

            romFile.Close();
        }

        static void DumpFanEnemyText()
        {
            string romName = "ff6skyrender.smc";
            FanTableReader_Script ff6ItemTable = new FanTableReader_Script("fan-item-table.txt");
            Console.OutputEncoding = System.Text.Encoding.UTF8;
            FileStream romFile = new FileStream(romName, FileMode.Open);

            for (int j = 0; j < 512; j++)
            {
                int loc = 0x304C00 + j * 2;
                romFile.Seek(loc, SeekOrigin.Begin);
                int offset = romFile.ReadByte() | (romFile.ReadByte() << 8);

                loc = 0x310000 + offset;
                string line = "";

                line = ff6ItemTable.GetLine(romFile, loc, 5000);

                fanEnemyText[j] = line;

                if (ff6ItemTable.convertToHTML)
                {
                    Console.WriteLine("<div id=\"fan-enemytext-" + j.ToString() + "\">" + line + "</div>");
                }
                else
                {
                    Console.WriteLine(line);
                }
            }

            romFile.Close();
        }

        static void DumpFanBattleDialogue()
        {
            string romName = "ff6skyrender.smc";
            FanTableReader_Script ff6ItemTable = new FanTableReader_Script("fan-item-table.txt");
            Console.OutputEncoding = System.Text.Encoding.UTF8;
            FileStream romFile = new FileStream(romName, FileMode.Open);

            for (int j = 0; j < 256; j++)
            {
                int loc = 0x304A00 + j * 2;
                romFile.Seek(loc, SeekOrigin.Begin);
                int offset = romFile.ReadByte() | (romFile.ReadByte() << 8);

                loc = 0x300000 + offset;
                string line = "";

                line = ff6ItemTable.GetLine(romFile, loc, 5000, true, true);

                fanBattleDialogue[j] = line;

                if (ff6ItemTable.convertToHTML)
                {
                    Console.WriteLine("<div id=\"fan-battledialogue-" + j.ToString() + "\">" + line + "</div>");
                }
                else
                {
                    Console.WriteLine(line);
                }
            }

            romFile.Close();
        }

        static void DumpFanItemDescriptions()
        {
            string romName = "ff6skyrender.smc";
            FanTableReader_Script ff6ItemTable = new FanTableReader_Script("fan-item-table.txt");
            Console.OutputEncoding = System.Text.Encoding.UTF8;
            FileStream romFile = new FileStream(romName, FileMode.Open);

            for (int j = 0; j < 256; j++)
            {
                int loc = 0x313200 + j * 2;
                romFile.Seek(loc, SeekOrigin.Begin);
                int offset = romFile.ReadByte() | (romFile.ReadByte() << 8);

                //Console.WriteLine(offset.ToString("X"));

                loc = 0x310000 + offset;
                string line = "";

                line = ff6ItemTable.GetLine(romFile, loc, 5000);

                fanItems[j] = line;

                if (ff6ItemTable.convertToHTML)
                {
                    Console.WriteLine("<div id=\"fan-itemdescription-" + j.ToString() + "\">" + line + "</div>");
                }
                else
                {
                    Console.WriteLine(line);
                }
            }

            romFile.Close();
        }










        static void DumpGBAText()
        {
            string romName = "ff6.gba";
            GBATableReader_Script gbaScriptTable = new GBATableReader_Script("gba-script-table.txt");
            GBAItemTableReader_Script gbaItemTable = new GBAItemTableReader_Script("gba-item-table.txt");
            Console.OutputEncoding = System.Text.Encoding.UTF8;
            FileStream romFile = new FileStream(romName, FileMode.Open);

            gbaScriptTable.convertToHTML = false;

            //0-3262 is main script
            /*for (int j = 0; j < 3262; j++)
            {
                int loc = (0x174454 + 0x10) + j * 4;
                romFile.Seek(loc, SeekOrigin.Begin);
                int offset = romFile.ReadByte() | (romFile.ReadByte() << 8) | (romFile.ReadByte() << 16) | (romFile.ReadByte() << 24);
                int lineStart = 0x174454 + offset;

                string line = gbaScriptTable.GetLine(romFile, lineStart);
                gbaStrings[j] = line;
            }*/

            //System.IO.File.WriteAllLines("ff6-gba-POOP.txt", gbaStrings);


            /*int index = 0;
            //3262-6114 is rest of text
            // dumping enemy moves
            index = 0;
            for (int j = 3262; j < 3685; j++)
            {
                int loc = (0x174454 + 0x10) + j * 4;
                romFile.Seek(loc, SeekOrigin.Begin);
                int offset = romFile.ReadByte() | (romFile.ReadByte() << 8) | (romFile.ReadByte() << 16) | (romFile.ReadByte() << 24);
                int lineStart = 0x174454 + offset;

                string line = gbaScriptTable.GetLine(romFile, lineStart);
                gbaStrings[j] = line;

                if (gbaScriptTable.convertToHTML)
                {
                    Console.WriteLine("<div id=\"gba-enemymove-" + index.ToString() + "\">" + line + "</div>");
                }
                else
                {
                    Console.WriteLine(line);
                }

                index++;
            }*/

            
            // dumping enemy text
            /*int index = 0;
            for (int j = 3685; j < 3685 + 256; j++)
            {
                int loc = (0x174454 + 0x10) + j * 4;
                romFile.Seek(loc, SeekOrigin.Begin);
                int offset = romFile.ReadByte() | (romFile.ReadByte() << 8) | (romFile.ReadByte() << 16) | (romFile.ReadByte() << 24);
                int lineStart = 0x174454 + offset;

                string line = gbaScriptTable.GetLine(romFile, lineStart);
                gbaStrings[j] = line;
                gbaEnemyText[index] = line;

                //line += "\n--------------------";

                //Console.WriteLine(line);

                index++;
            }*/


            // 3941-4013 don't dump properly, not sure what they are

            // dumping battle dialogue
            /*int index = 0;
            for (int j = 4014; j < 4270; j++)
            {
                int loc = (0x174454 + 0x10) + j * 4;
                romFile.Seek(loc, SeekOrigin.Begin);
                int offset = romFile.ReadByte() | (romFile.ReadByte() << 8) | (romFile.ReadByte() << 16) | (romFile.ReadByte() << 24);
                int lineStart = 0x174454 + offset;

                string line = gbaScriptTable.GetLine(romFile, lineStart, 5000, true);
                gbaStrings[j] = line;

                gbaBattleDialogue[index] = line;
                //gbaBattleDialogue[index] = lineStart.ToString("X8") + "\n" + line;

                index++;
            }*/

            //System.IO.File.WriteAllLines("ff6-gba-battle-dialogue.txt", gbaBattleDialogue);


            // dumping battle dialogue
            /*int index = 0;
            for (int j = 4270; j < 4526; j++)
            {
                int loc = (0x174454 + 0x10) + j * 4;
                romFile.Seek(loc, SeekOrigin.Begin);
                int offset = romFile.ReadByte() | (romFile.ReadByte() << 8) | (romFile.ReadByte() << 16) | (romFile.ReadByte() << 24);
                int lineStart = 0x174454 + offset;

                string line = gbaScriptTable.GetLine(romFile, lineStart);
                gbaStrings[j] = line;

                index++;
                Console.WriteLine(line);
            }*/

            // entries 4526 to 4557 don't dump properly, not sure what they are
            // item names
            /*int index = 0;
            for (int j = 4558; j < 4829; j++)
            {
                int loc = (0x174454 + 0x10) + j * 4;
                romFile.Seek(loc, SeekOrigin.Begin);
                int offset = romFile.ReadByte() | (romFile.ReadByte() << 8) | (romFile.ReadByte() << 16) | (romFile.ReadByte() << 24);
                int lineStart = 0x174454 + offset;

                string line = gbaScriptTable.GetLine(romFile, lineStart);
                gbaStrings[j] = line;

                Console.WriteLine(line);


                index++;
            }*/
            
            // entries 4829-5100 appear to be item descriptions but in a diff format?
            // 816C8A1 is start of mythril knife desc
            // going past 271 will dump other descriptions for other things!
            int index = 0;
            for (int j = 0; j < 271; j++)
            {
                int loc = (0x1654F8 + 0x10) + (j + 1529) * 4;
                romFile.Seek(loc, SeekOrigin.Begin);
                int offset = romFile.ReadByte() | (romFile.ReadByte() << 8) | (romFile.ReadByte() << 16) | (romFile.ReadByte() << 24);
                int lineStart = 0x1654F8 + offset;

                string line = gbaItemTable.GetLine(romFile, lineStart);
                gbaStrings[j] = line;
                gbaItemDescriptions[index] = line;
                //Console.WriteLine(lineStart.ToString("X"));


                //Console.WriteLine(line);



                index++;
            }

            /*
            // move names, this has to be rearranged in a certain way so it's kinda ugly here
            index = 0;
            // magic, etc. skill names
            // for some reason index 54-56 have diff names in the GBA version and aren't espers but flood, gravija, and valor???
            for (int j = 5101; j < 5392; j++)
            {
                int loc = (0x174454 + 0x10) + j * 4;
                romFile.Seek(loc, SeekOrigin.Begin);
                int offset = romFile.ReadByte() | (romFile.ReadByte() << 8) | (romFile.ReadByte() << 16) | (romFile.ReadByte() << 24);
                int lineStart = 0x174454 + offset;

                string line = gbaScriptTable.GetLine(romFile, lineStart);
                gbaStrings[j] = line;

                if (gbaScriptTable.convertToHTML)
                {
                    Console.WriteLine("<div id=\"gba-move-" + index.ToString() + "\">" + line + "</div>");
                }
                else
                {
                    Console.WriteLine(line);
                }

                index++;
            }

            // sword skill names
            for (int j = 5093; j < 5101; j++)
            {
                int loc = (0x174454 + 0x10) + j * 4;
                romFile.Seek(loc, SeekOrigin.Begin);
                int offset = romFile.ReadByte() | (romFile.ReadByte() << 8) | (romFile.ReadByte() << 16) | (romFile.ReadByte() << 24);
                int lineStart = 0x174454 + offset;

                string line = gbaScriptTable.GetLine(romFile, lineStart);
                gbaStrings[j] = line;

                if (gbaScriptTable.convertToHTML)
                {
                    Console.WriteLine("<div id=\"gba-move-" + index.ToString() + "\">" + line + "</div>");
                }
                else
                {
                    Console.WriteLine(line);
                }

                index++;
            }

            // new gba skill names
            for (int j = 5392; j < 5400; j++)
            {
                int loc = (0x174454 + 0x10) + j * 4;
                romFile.Seek(loc, SeekOrigin.Begin);
                int offset = romFile.ReadByte() | (romFile.ReadByte() << 8) | (romFile.ReadByte() << 16) | (romFile.ReadByte() << 24);
                int lineStart = 0x174454 + offset;

                string line = gbaScriptTable.GetLine(romFile, lineStart);
                gbaStrings[j] = line;

                if (gbaScriptTable.convertToHTML)
                {
                    Console.WriteLine("<div id=\"gba-move-" + index.ToString() + "\">" + line + "</div>");
                }
                else
                {
                    Console.WriteLine(line);
                }

                index++;
            }

            // entries 5400 to 5473 don't dump properly, not sure what they are

            // place names
            index = 0;
            for (int j = 5474; j < 5549; j++)
            {
                int loc = (0x174454 + 0x10) + j * 4;
                romFile.Seek(loc, SeekOrigin.Begin);
                int offset = romFile.ReadByte() | (romFile.ReadByte() << 8) | (romFile.ReadByte() << 16) | (romFile.ReadByte() << 24);
                int lineStart = 0x174454 + offset;

                string line = gbaScriptTable.GetLine(romFile, lineStart);
                gbaStrings[j] = line;

                if (gbaScriptTable.convertToHTML)
                {
                    Console.WriteLine("<div id=\"gba-placename-" + index.ToString() + "\">" + line + "</div>");
                }
                else
                {
                    Console.WriteLine(line);
                }

                index++;
            }*/

            // enemy names
            /*int index = 0;
            for (int j = 5670; j < 6093; j++)
            {
                int loc = (0x174454 + 0x10) + j * 4;
                romFile.Seek(loc, SeekOrigin.Begin);
                int offset = romFile.ReadByte() | (romFile.ReadByte() << 8) | (romFile.ReadByte() << 16) | (romFile.ReadByte() << 24);
                int lineStart = 0x174454 + offset;

                string line = gbaScriptTable.GetLine(romFile, lineStart);
                gbaStrings[j] = line;
                gbaEnemies[index] = line;
                    
                //Console.WriteLine(line);

                index++;
            }*/

            romFile.Close();
        }











        static void DumpFF6Text()
        {
            string romName = "ff6.smc";
            FF6TableReader_Script ff6ScriptTable = new FF6TableReader_Script("ff6-script-table.txt");
            Console.OutputEncoding = System.Text.Encoding.UTF8;
            FileStream romFile = new FileStream(romName, FileMode.Open);

            // The 16-bit number here tells the game when to jump to a new text bank if a line ID is >= to it
            romFile.Seek(0xCE600, SeekOrigin.Begin);
            int newBankID = romFile.ReadByte() | (romFile.ReadByte() << 8);

            for (int j = 0; j < 3451; j++)  // 3084 before
            {
                int loc = 0xCE602 + j * 2;
                romFile.Seek(loc, SeekOrigin.Begin);
                int offset = romFile.ReadByte() | (romFile.ReadByte() << 8);
                string line = "";

                // offset FFFF indicates the line doesn't exist
                if (offset != 0xFFFF)
                {
                    int lineStart = 0xD0000 + offset;
                    if (j >= newBankID)
                    {
                        lineStart += 0x10000;
                    }
                    line = ff6ScriptTable.GetLine(romFile, lineStart);

                    //Console.WriteLine(lineStart.ToString("X6"));
                }

                ff6Strings[j] = line; // j.ToString() + "\n" + line;

                

                /*if (ff6ScriptTable.convertToHTML)
                {
                    Console.WriteLine("<div id=\"script-bank-1-" + j.ToString() + "\">" + line + "</div>");
                }
                else
                {
                    Console.WriteLine(line);
                }*/
            }

            System.IO.File.WriteAllLines("ff6-j-script.txt", ff6Strings);

            romFile.Close();
        }

        static void DumpFF6Items()
        {
            string romName = "ff6.smc";
            FF6TableReader_Item ff6ItemTable = new FF6TableReader_Item("ff6-item-table.txt");
            Console.OutputEncoding = System.Text.Encoding.UTF8;
            FileStream romFile = new FileStream(romName, FileMode.Open);

            for (int j = 0; j < 256; j++)
            {
                int loc = 0x26F700 + j * 9;
                romFile.Seek(loc, SeekOrigin.Begin);
                string line = "";

                line = ff6ItemTable.GetLine(romFile, loc + 1, 8, true);

                line = line.Replace("[FF]", "");
                ff6Items[j] = line;


                //Console.WriteLine(line);

            }

            romFile.Close();
        }

        static void DumpFF6Enemies()
        {
            string romName = "ff6.smc";
            FF6TableReader_Battle ff6ItemTable = new FF6TableReader_Battle("ff6-battle-table.txt");
            Console.OutputEncoding = System.Text.Encoding.UTF8;
            FileStream romFile = new FileStream(romName, FileMode.Open);

            for (int j = 0; j < 384; j++)
            {
                int loc = 0xFC800 + j * 8;
                romFile.Seek(loc, SeekOrigin.Begin);
                string line = "";

                line = ff6ItemTable.GetLine(romFile, loc, 8, true);

                ff6Enemies[j] = line;

                //Console.WriteLine(line);
            }

            romFile.Close();
        }

        static void DumpFF6EnemyMoves()
        {
            string romName = "ff6.smc";
            FF6TableReader_Battle ff6ItemTable = new FF6TableReader_Battle("ff6-battle-table.txt");
            Console.OutputEncoding = System.Text.Encoding.UTF8;
            FileStream romFile = new FileStream(romName, FileMode.Open);

            for (int j = 0; j < 384; j++)
            {
                int loc = 0xFD400 + j * 8;
                romFile.Seek(loc, SeekOrigin.Begin);
                string line = "";

                line = ff6ItemTable.GetLine(romFile, loc, 8, true);

                ff6EnemyMoves[j] = line;

                //Console.WriteLine(line);
            }

            romFile.Close();
        }

        static void DumpFF6Moves()
        {
            string romName = "ff6.smc";
            FF6TableReader_Script ff6ItemTable = new FF6TableReader_Script("ff6-item-table.txt");
            Console.OutputEncoding = System.Text.Encoding.UTF8;
            FileStream romFile = new FileStream(romName, FileMode.Open);

            int index = 0;

            // MAGIC SPELL NAMES
            for (int j = 0; j < 54 ; j++)
            {
                int loc = 0x2D7400 + j * 5;
                romFile.Seek(loc, SeekOrigin.Begin);
                string line = ff6ItemTable.GetLine(romFile, loc, 5, true);
                ff6Moves[index] = line;

                if (ff6ItemTable.convertToHTML)
                {
                    Console.WriteLine("<div id=\"jpn-move-" + index.ToString() + "\">" + line + "</div>");
                }
                else
                {
                    Console.WriteLine(line);
                }
                
                index++;
            }

            // OTHER SPELL NAMES
            for (int j = 0; j < 202; j++)
            {
                int loc = 0x2D750E + j * 8;
                romFile.Seek(loc, SeekOrigin.Begin);
                string line = ff6ItemTable.GetLine(romFile, loc, 8, true);
                ff6Moves[index] = line;

                if (ff6ItemTable.convertToHTML)
                {
                    Console.WriteLine("<div id=\"jpn-move-" + index.ToString() + "\">" + line + "</div>");
                }
                else
                {
                    Console.WriteLine(line);
                }

                index++;
            }

            // ESPER ATTACK NAMES
            for (int j = 0; j < 27; j++)
            {
                int loc = 0x2D7B5E + j * 9;
                romFile.Seek(loc, SeekOrigin.Begin);
                string line = ff6ItemTable.GetLine(romFile, loc, 9, true);
                ff6Moves[index] = line;

                if (ff6ItemTable.convertToHTML)
                {
                    Console.WriteLine("<div id=\"jpn-move-" + index.ToString() + "\">" + line + "</div>");
                }
                else
                {
                    Console.WriteLine(line);
                }

                index++;
            }

            // MOG DANCE NAMES
            for (int j = 0; j < 8; j++)
            {
                int loc = 0x2D7C51 + j * 8;
                romFile.Seek(loc, SeekOrigin.Begin);
                string line = ff6ItemTable.GetLine(romFile, loc, 8, true);
                ff6Moves[index] = line;

                if (ff6ItemTable.convertToHTML)
                {
                    Console.WriteLine("<div id=\"jpn-move-" + index.ToString() + "\">" + line + "</div>");
                }
                else
                {
                    Console.WriteLine(line);
                }

                index++;
            }

            romFile.Close();
        }

        static void DumpFF6EnemyText()
        {
            string romName = "ff6.smc";
            FF6TableReader_Battle table = new FF6TableReader_Battle("ff6-battle-table.txt");
            Console.OutputEncoding = System.Text.Encoding.UTF8;
            FileStream romFile = new FileStream(romName, FileMode.Open);

            for (int j = 0; j < 256; j++)
            {
                int loc = 0xFE000 + j * 2;
                romFile.Seek(loc, SeekOrigin.Begin);
                int offset = romFile.ReadByte() | (romFile.ReadByte() << 8);

                string line = table.GetLine(romFile, 0xF0000 + offset);
                ff6EnemyText[j] = line;

                Console.WriteLine(line);
            }

            romFile.Close();
        }

        static void DumpFF6BattleDialogue()
        {
            string romName = "ff6.smc";
            FF6TableReader_Battle table = new FF6TableReader_Battle("ff6-battle-table.txt");
            Console.OutputEncoding = System.Text.Encoding.UTF8;
            FileStream romFile = new FileStream(romName, FileMode.Open);

            for (int j = 0; j < 256; j++)
            {
                int loc = 0x10FC00 + j * 2;
                romFile.Seek(loc, SeekOrigin.Begin);
                int offset = romFile.ReadByte() | (romFile.ReadByte() << 8);

                string line = "";

                line = table.GetLine(romFile, 0x100000 + offset, 5000);

                ff6BattleDialogue[j] = line;

                //Console.WriteLine((0x100000 + offset).ToString("X6"));
                //Console.WriteLine(line);
            }

            romFile.Close();
        }

        static void DumpFF6BattleText()
        {
            string romName = "ff6.smc";
            FF6TableReader_Battle table = new FF6TableReader_Battle("ff6-battle-table.txt");
            Console.OutputEncoding = System.Text.Encoding.UTF8;
            FileStream romFile = new FileStream(romName, FileMode.Open);

            for (int j = 0; j < 256; j++)
            {
                int loc = 0xF3940 + j * 2;
                romFile.Seek(loc, SeekOrigin.Begin);
                int offset = romFile.ReadByte() | (romFile.ReadByte() << 8);

                string line = "";

                line = table.GetLine(romFile, 0x110000 + offset, 5000);

                ff6BattleText[j] = line;

                //Console.WriteLine((offset + 0x110000).ToString("X6") + " " + line);
                Console.WriteLine(line);
            }

            romFile.Close();
        }

        static void DumpFF6PlaceNames()
        {
            string romName = "ff6.smc";
            FF6TableReader_Script ff6ItemTable = new FF6TableReader_Script("ff6-item-table.txt");
            Console.OutputEncoding = System.Text.Encoding.UTF8;
            FileStream romFile = new FileStream(romName, FileMode.Open);

            for (int j = 0; j < 73; j++)
            {
                int loc = 0x268400 + j * 2;
                romFile.Seek(loc, SeekOrigin.Begin);
                int offset = romFile.ReadByte() | (romFile.ReadByte() << 8);

                string line = "";

                line = ff6ItemTable.GetLine(romFile, 0x2684C0 + offset, 5000, true, true);

                ff6PlaceNames[j] = line;

                if (ff6ItemTable.convertToHTML)
                {
                    Console.WriteLine("<div id=\"jpn-placename-" + j.ToString() + "\">" + line + "</div>");
                }
                else
                {
                    Console.WriteLine(line);
                }

                //Console.WriteLine(offset);
            }

            romFile.Close();
        }

        static void DumpFF6ItemDescriptions()
        {
            string romName = "ff6.smc";
            FF6TableReader_Script ff6ItemTable = new FF6TableReader_Script("ff6-script-table.txt");
            Console.OutputEncoding = System.Text.Encoding.UTF8;
            FileStream romFile = new FileStream(romName, FileMode.Open);

            for (int j = 0; j < 256; j++)
            {
                int loc = 0x186E00 + j * 2;
                romFile.Seek(loc, SeekOrigin.Begin);
                int offset = romFile.ReadByte() | (romFile.ReadByte() << 8);

                string line = "";

                line = ff6ItemTable.GetLine(romFile, 0x2D6400 + offset);

                ff6ItemDescriptions[j] = line;
                

                //Console.WriteLine(line);
                //Console.WriteLine(offset.ToString("X"));
            }

            romFile.Close();
        }





























        static void DumpFF6TEditionText(string romName, string bank1Name, string bank2Name)
        {
            //string romName = "ff6t.smc";
            FF6TEditionTableReader_Script ff6TEditionScriptTable = new FF6TEditionTableReader_Script("ff6t-script-table.txt");
            Console.OutputEncoding = System.Text.Encoding.UTF8;
            FileStream romFile = new FileStream(romName, FileMode.Open);

            int lineStart = 0;

            // BANK 1 (BASED ON ORIGINAL BANK 1 BUT HAS CHANGES AND ADDITIONS)
            // The 16-bit number here tells the game when to jump to a new text bank if a line ID is >= to it
            romFile.Seek(0x550000, SeekOrigin.Begin);
            int newBankID = romFile.ReadByte() | (romFile.ReadByte() << 8);
            for (int j = 0; j < 3451; j++)
            {
                if (j == 283)
                {
                    int p = 323;
                }

                int loc = 0x550002 + j * 2;
                romFile.Seek(loc, SeekOrigin.Begin);
                int offset = romFile.ReadByte() | (romFile.ReadByte() << 8);
                string line = "";

                // offset FFFF indicates the line doesn't exist
                if (offset != 0xFFFF)
                {
                    lineStart = 0x520000 + offset;
                    if (j >= newBankID)
                    {
                        lineStart += 0x10000;
                    }
                    line = ff6TEditionScriptTable.GetLine(romFile, lineStart);

                    //Console.WriteLine(lineStart.ToString("X6"));
                }

                ff6TEditionStringsBank1[j] = line;

                /*if (ff6TEditionScriptTable.convertToHTML)
                {
                    Console.WriteLine("<div id=\"script-bank-1-" + j.ToString() + "\">" + line + "</div>");
                }
                else
                {
                    Console.WriteLine(line);
                }*/
            }

            /*for (int j = 0; j < 3451; j++)
            {
                ff6TEditionStringsBank1[j] += str += "\n--------------------";
            }*/

            //Console.WriteLine("FF6T Bank 1 Last Line Start: " + lineStart.ToString("X6"));

            System.IO.File.WriteAllLines(bank1Name, ff6TEditionStringsBank1);


            // BANK 2 (ALL NEW STUFF?)
            // The 16-bit number here tells the game when to jump to a new text bank if a line ID is >= to it
            romFile.Seek(0x51E600, SeekOrigin.Begin);
            newBankID = romFile.ReadByte() | (romFile.ReadByte() << 8);
            for (int j = 0; j < 1262; j++)
            {
                int loc = 0x51E602 + j * 2;
                romFile.Seek(loc, SeekOrigin.Begin);
                int offset = romFile.ReadByte() | (romFile.ReadByte() << 8);
                string line = "";

                // offset FFFF indicates the line doesn't exist
                if (offset != 0xFFFF & offset != 0x0000)
                {
                    lineStart = 0x560000 + offset;
                    if (j >= newBankID)
                    {
                        lineStart += 0x10000;
                    }
                    line = ff6TEditionScriptTable.GetLine(romFile, lineStart);

                    //Console.WriteLine(lineStart.ToString("X6"));
                }

                ff6TEditionStringsBank2[j] = line;

                /*if (ff6TEditionScriptTable.convertToHTML)
                {
                    Console.WriteLine("<div id=\"script-bank-2-" + j.ToString() + "\">" + line + "</div>");
                }
                else
                {
                    Console.WriteLine(line);
                }*/
            }

            //Console.WriteLine("\n\nFF6T Bank 2 Last Line Start: " + lineStart.ToString("X6"));

            System.IO.File.WriteAllLines(bank2Name, ff6TEditionStringsBank2);

            romFile.Close();
        }




        static void DumpFF6TPlaceNames(string romName, int pointerBlockStart, int textDataOffset)
        {
            FF6TEditionTableReader_Script table = new FF6TEditionTableReader_Script("ff6t-script-table.txt");
            Console.OutputEncoding = System.Text.Encoding.UTF8;
            FileStream romFile = new FileStream(romName, FileMode.Open);

            for (int j = 0; j < 127; j++)
            {
                int loc = pointerBlockStart + j * 2;
                romFile.Seek(loc, SeekOrigin.Begin);
                int offset = romFile.ReadByte() | (romFile.ReadByte() << 8);

                string line = "";

                line = table.GetLine(romFile, textDataOffset + offset, 5000, true, true);

                ff6TPlaceNames[j] = line;
            }

            romFile.Close();
        }



        static void DumpFF6TEditionEnemyMoves(string romName, string tableName, int startLoc = 0x5f4500)
        {
            FF6TableReader_Battle ff6TEditionScriptTable = new FF6TableReader_Battle(tableName);
            Console.OutputEncoding = System.Text.Encoding.UTF8;
            FileStream romFile = new FileStream(romName, FileMode.Open);

            for (int i = 0; i < 510; i++)
            {
                int loc = startLoc + i * 10;
                romFile.Seek(loc, SeekOrigin.Begin);
                string line = ff6TEditionScriptTable.GetLine(romFile, loc, 10);
                ff6TEnemyMoves[i] = line;

                //Console.WriteLine(line);
            }
            romFile.Close();
        }


        static void DumpFF6TEditionAttackNames(string romName, string tableName)
        {
            FF6TableReader_Battle table = new FF6TableReader_Battle(tableName);
            Console.OutputEncoding = System.Text.Encoding.UTF8;
            FileStream romFile = new FileStream(romName, FileMode.Open);

            //(WITH KANJI!) enemy special attacks + player special attack names
            for (int i = 0; i < 202; i++)
            {
                int loc = 0x58F10E + i * 9; // ff6t
                romFile.Seek(loc, SeekOrigin.Begin);
                string line = table.GetLine(romFile, loc, 9);

                ff6TAttackNames[i] = line;

                //Console.WriteLine(line);
            }

            romFile.Close();
        }


        static void DumpFF6TMenuActions(string romName, string tableName)
        {
            FF6TableReader_Battle table = new FF6TableReader_Battle(tableName);
            Console.OutputEncoding = System.Text.Encoding.UTF8;
            FileStream romFile = new FileStream(romName, FileMode.Open);

            int index = 0;
            for (int j = 0; j < 30; j++)
            {
                int loc = 0x2Ce2e0 + j * 6;
                romFile.Seek(loc, SeekOrigin.Begin);
                string line = table.GetLine(romFile, loc, 6, true);
                ff6TMenuActions[j] = line;

                //Console.WriteLine(line);

                index++;
            }

            romFile.Close();
        }


        static void DumpFF6TEditionBlueMagicNames(string romName, string tableName)
        {
            FF6TableReader_Battle table = new FF6TableReader_Battle(tableName);
            Console.OutputEncoding = System.Text.Encoding.UTF8;
            FileStream romFile = new FileStream(romName, FileMode.Open);

            for (int i = 0; i < 32; i++)
            {
                int loc = 0x58EF00 + i * 8;
                romFile.Seek(loc, SeekOrigin.Begin);
                string line = table.GetLine(romFile, loc, 8);
                ff6TBlueMagicNames[i] = line;

                //Console.WriteLine(line);
            }

            romFile.Close();
        }


        static void DumpFF6TEditionDanceNames(string romName, string tableName)
        {
            FF6TableReader_Battle table = new FF6TableReader_Battle(tableName);
            Console.OutputEncoding = System.Text.Encoding.UTF8;
            FileStream romFile = new FileStream(romName, FileMode.Open);

            int index = 0;
            for (int j = 0; j < 8; j++)
            {
                int loc = 0x2D7C51 + j * 8;
                romFile.Seek(loc, SeekOrigin.Begin);
                string line = table.GetLine(romFile, loc, 8, true);
                ff6TDanceNames[j] = line;
                //Console.WriteLine(line);

                index++;
            }

            romFile.Close();
        }


        static void DumpFF6TEsperAttackNames(string romName, string tableName)
        {
            FF6TableReader_Battle table = new FF6TableReader_Battle(tableName);
            Console.OutputEncoding = System.Text.Encoding.UTF8;
            FileStream romFile = new FileStream(romName, FileMode.Open);

            for (int j = 0; j < 27; j++)
            {
                int loc = 0x2D7B5E + j * 9;
                romFile.Seek(loc, SeekOrigin.Begin);
                string line = table.GetLine(romFile, loc, 9, true);
                ff6TEsperAttackNames[j] = line;
                //Console.WriteLine(line);
            }

            romFile.Close();
        }


        static void DumpFF6TEsperNames(string romName, string tableName)
        {
            FF6TableReader_Battle table = new FF6TableReader_Battle(tableName);
            Console.OutputEncoding = System.Text.Encoding.UTF8;
            FileStream romFile = new FileStream(romName, FileMode.Open);

            for (int i = 0; i < 28; i++)
            {
                int loc = 0x58EE20 + i * 8;
                //int loc = 0x58F001 + i * 5;
                romFile.Seek(loc, SeekOrigin.Begin);
                string line = table.GetLine(romFile, loc, 8);
                //Console.WriteLine(line);
                ff6TEsperNames[i] = line;
            }

            romFile.Close();
        }


        static void DumpFF6TMagicNames(string romName, string tableName)
        {
            FF6TableReader_Battle table = new FF6TableReader_Battle(tableName);
            Console.OutputEncoding = System.Text.Encoding.UTF8;
            FileStream romFile = new FileStream(romName, FileMode.Open);

            for (int i = 0; i < 54; i++)
            {
                int loc = 0x58F000 + i * 5;
                romFile.Seek(loc, SeekOrigin.Begin);
                string line = table.GetLine(romFile, loc, 5);
                ff6TMagicNames[i] = line;
                //Console.WriteLine(line)
            }

            romFile.Close();
        }




        static void DumpFF6TEditionMoves(string romName, string itemTableName, string battleTableName)
        {
            FF6TableReader_Item itemTable = new FF6TableReader_Item(itemTableName);
            FF6TableReader_Battle battleTable = new FF6TableReader_Battle(battleTableName);
            Console.OutputEncoding = System.Text.Encoding.UTF8;
            FileStream romFile = new FileStream(romName, FileMode.Open);


            // (ALL KANA) enemy special attacks + player special attack names
            /*for (int i = 0; i < 202; i++)
            {
                int loc = 0x58F830 + i * 8;
                romFile.Seek(loc, SeekOrigin.Begin);
                string line = battleTable.GetLine(romFile, loc, 8);

                Console.WriteLine(line);
            }*/

            romFile.Close();
        }


        static void DumpFF6TEditionCharacterNames(string romName)
        {
            FF6TableReader_Script ff6TEditionScriptTable = new FF6TableReader_Script("ff6t-script-table.txt");
            Console.OutputEncoding = System.Text.Encoding.UTF8;
            FileStream romFile = new FileStream(romName, FileMode.Open);

            for (int i = 0; i < 64; i++)
            {
                int loc = 0x478c0 + i * 6;
                romFile.Seek(loc, SeekOrigin.Begin);
                string line = ff6TEditionScriptTable.GetLine(romFile, loc, 6);
                ff6TCharacterNames[i] = line;

                //Console.WriteLine(line);
            }
            romFile.Close();
        }


        static void DumpFF6TEditionRareItems(string romName)
        {
            FF6TableReader_Script ff6TEditionScriptTable = new FF6TableReader_Script("ff6t-script-table.txt");
            Console.OutputEncoding = System.Text.Encoding.UTF8;
            FileStream romFile = new FileStream(romName, FileMode.Open);

            for (int i = 0; i < 30; i++)
            {
                int loc = 0xefba0 + i * 8;
                romFile.Seek(loc, SeekOrigin.Begin);
                string line = ff6TEditionScriptTable.GetLine(romFile, loc, 8);
                ff6TRareItems[i] = line;

                //Console.WriteLine(line);
            }
            romFile.Close();
        }


        static void DumpFF6TEditionRareItemDescriptions(string romName)
        {
            FF6TableReader_Script table = new FF6TableReader_Script("ff6t-script-table.txt");
            Console.OutputEncoding = System.Text.Encoding.UTF8;
            FileStream romFile = new FileStream(romName, FileMode.Open);

            for (int i = 0; i < 30; i++)
            {
                int pointerLoc = 0xefb60 + i * 2;
                romFile.Seek(pointerLoc, SeekOrigin.Begin);
                int offset = romFile.ReadByte() | (romFile.ReadByte() << 8);

                int loc = 0xefc90 + offset;
                romFile.Seek(loc, SeekOrigin.Begin);
                string line = table.GetLine(romFile, loc);
                ff6TRareItemDescriptions[i] = line;

                //Console.WriteLine(line);
            }
            romFile.Close();
        }


        static void DumpFF6TEditionItemDescriptions(string romName)
        {
            FF6TableReader_Script table = new FF6TableReader_Script("ff6t-script-table.txt");
            Console.OutputEncoding = System.Text.Encoding.UTF8;
            FileStream romFile = new FileStream(romName, FileMode.Open);

            for (int i = 0; i < 279; i++)
            {
                int pointerLoc = 0x41000 + i * 2;
                romFile.Seek(pointerLoc, SeekOrigin.Begin);
                int offset = romFile.ReadByte() | (romFile.ReadByte() << 8);

                int loc = 0x420000 + offset;
                romFile.Seek(loc, SeekOrigin.Begin);
                string line = table.GetLine(romFile, loc);

                ff6TItemDescriptions[i] = line;

                //Console.WriteLine(loc.ToString("X6"));

                //Console.WriteLine(line);
            }
            romFile.Close();
        }


        static void DumpFF6TEditionEsperAttackDescriptions(string romName)
        {
            FF6TableReader_Script table = new FF6TableReader_Script("ff6t-script-table.txt");
            Console.OutputEncoding = System.Text.Encoding.UTF8;
            FileStream romFile = new FileStream(romName, FileMode.Open);

            for (int i = 0; i < 27; i++)
            {
                int pointerLoc = 0xffe40 + i * 2;
                romFile.Seek(pointerLoc, SeekOrigin.Begin);
                int offset = romFile.ReadByte() | (romFile.ReadByte() << 8);

                int loc = 0x41cda0 + offset;
                romFile.Seek(loc, SeekOrigin.Begin);
                string line = table.GetLine(romFile, loc);

                ff6TEsperAttackDescriptions[i] = line;

                //Console.WriteLine(loc.ToString("X6"));

                //Console.WriteLine(line);
            }
            romFile.Close();
        }


        static void DumpFF6TEditionMagicDescriptions(string romName)
        {
            FF6TableReader_Script table = new FF6TableReader_Script("ff6t-script-table.txt");
            Console.OutputEncoding = System.Text.Encoding.UTF8;
            FileStream romFile = new FileStream(romName, FileMode.Open);

            for (int i = 0; i < 54; i++)
            {
                int pointerLoc = 0x26f690 + i * 2;
                romFile.Seek(pointerLoc, SeekOrigin.Begin);
                int offset = romFile.ReadByte() | (romFile.ReadByte() << 8);

                int loc = 0x18c9a0 + offset;
                romFile.Seek(loc, SeekOrigin.Begin);
                string line = table.GetLine(romFile, loc);

                ff6TMagicDescriptions[i] = line;

                //Console.WriteLine(loc.ToString("X6"));

                //Console.WriteLine(line);
            }
            romFile.Close();
        }


        static void DumpFF6TEditionSwordTechDescriptions(string romName)
        {
            FF6TableReader_Script table = new FF6TableReader_Script("ff6t-script-table.txt");
            Console.OutputEncoding = System.Text.Encoding.UTF8;
            FileStream romFile = new FileStream(romName, FileMode.Open);

            for (int i = 0; i < 8; i++)
            {
                int pointerLoc = 0xfffae + i * 2;
                romFile.Seek(pointerLoc, SeekOrigin.Begin);
                int offset = romFile.ReadByte() | (romFile.ReadByte() << 8);

                int loc = 0xffd00 + offset;
                romFile.Seek(loc, SeekOrigin.Begin);
                string line = table.GetLine(romFile, loc);
                ff6TSwordtechDescriptions[i] = line;

                //Console.WriteLine(line);
            }
            romFile.Close();
        }

        static void DumpFF6TEditionRageDescriptions(string romName)
        {
            FF6TableReader_Script table = new FF6TableReader_Script("ff6t-script-table.txt");
            Console.OutputEncoding = System.Text.Encoding.UTF8;
            FileStream romFile = new FileStream(romName, FileMode.Open);

            for (int i = 0; i < 255; i++)
            {
                int pointerLoc = 0x400e00 + i * 2;
                romFile.Seek(pointerLoc, SeekOrigin.Begin);
                int offset = romFile.ReadByte() | (romFile.ReadByte() << 8);

                int loc = 0x401000 + offset;
                romFile.Seek(loc, SeekOrigin.Begin);
                string line = table.GetLine(romFile, loc);

                ff6TRageDescriptions[i] = line;
                //Console.WriteLine(line);
            }
            romFile.Close();
        }


        static void DumpFF6TBattleDialogue(string romName)
        {
            FF6TableReader_Battle table = new FF6TableReader_Battle("ff6t-battle-table.txt");
            Console.OutputEncoding = System.Text.Encoding.UTF8;
            FileStream romFile = new FileStream(romName, FileMode.Open);

            for (int j = 0; j < 256; j++)
            {
                int loc = 0x10FC00 + j * 2;
                romFile.Seek(loc, SeekOrigin.Begin);
                int offset = romFile.ReadByte() | (romFile.ReadByte() << 8);

                string line = "";

                line = table.GetLine(romFile, 0x100000 + offset, 5000);

                ff6TBattleDialogue[j] = line;

                //Console.WriteLine((0x100000 + offset).ToString("X6"));
                //Console.WriteLine(line);
            }

            romFile.Close();
        }


        static void DumpFF6TBattleText(string romName)
        {
            FF6TableReader_Battle table = new FF6TableReader_Battle("ff6t-battle-table.txt");
            Console.OutputEncoding = System.Text.Encoding.UTF8;
            FileStream romFile = new FileStream(romName, FileMode.Open);

            for (int j = 0; j < 256; j++)
            {
                int loc = 0xF3940 + j * 2;
                romFile.Seek(loc, SeekOrigin.Begin);
                int offset = romFile.ReadByte() | (romFile.ReadByte() << 8);

                string line = "";

                line = table.GetLine(romFile, 0x110000 + offset, 5000);

                ff6TBattleText[j] = line;

                //Console.WriteLine((offset + 0x110000).ToString("X6") + " " + line);
                //Console.WriteLine(line);
            }

            romFile.Close();
        }


        static void DumpFF6TItems(string romName)
        {
            FF6TableReader_Item table = new FF6TableReader_Item("ff6t-item-table.txt");
            Console.OutputEncoding = System.Text.Encoding.UTF8;
            FileStream romFile = new FileStream(romName, FileMode.Open);

            for (int j = 0; j < 280; j++)
            {
                //int loc = 0x26F700 + j * 9;
                int loc = 0x185000 + j * 9;
                romFile.Seek(loc, SeekOrigin.Begin);
                string line = "";

                line = table.GetLine(romFile, loc, 9);
                line = table.GetLine(romFile, loc + 1, 8);
                line = line.Replace("[FF]", "");
                ff6TItems[j] = line;

                //Console.WriteLine(line);
            }

            romFile.Close();
        }


        static void DumpFF6TEnemyText(string romName, string tableFileName)
        {
            FF6TableReader_Battle ff6ItemTable = new FF6TableReader_Battle(tableFileName);
            Console.OutputEncoding = System.Text.Encoding.UTF8;
            FileStream romFile = new FileStream(romName, FileMode.Open);

            for (int j = 0; j < 256; j++)
            {
                int loc = 0xFE000 + j * 2;
                romFile.Seek(loc, SeekOrigin.Begin);
                int offset = romFile.ReadByte() | (romFile.ReadByte() << 8);

                string line = "";

                line = ff6ItemTable.GetLine(romFile, 0xF0000 + offset);

                ff6TEnemyText[j] = line;
                //Console.WriteLine(line);
            }

            romFile.Close();
        }


        static void DumpFF6TEnemies(string romName)
        {
            FF6TableReader_Battle ff6ItemTable = new FF6TableReader_Battle("ff6t-battle-table.txt");
            Console.OutputEncoding = System.Text.Encoding.UTF8;
            FileStream romFile = new FileStream(romName, FileMode.Open);

            for (int j = 0; j < 512; j++)
            //for (int j = 0; j < 384; j++)
            {
                int loc = 0xFC400 + j * 8;
                romFile.Seek(loc, SeekOrigin.Begin);
                string line = "";

                line = ff6ItemTable.GetLine(romFile, loc, 8, true);

                ff6TEnemies[j] = line;
                //Console.WriteLine(line);

                //Console.WriteLine("----" + loc.ToString("X6") + "\n" + line);
            }

            romFile.Close();
        }


        static void DumpFF6TEditionBlitzDescriptions(string romName)
        {
            FF6TableReader_Script table = new FF6TableReader_Script("ff6t-script-table.txt");
            Console.OutputEncoding = System.Text.Encoding.UTF8;
            FileStream romFile = new FileStream(romName, FileMode.Open);

            for (int i = 0; i < 8; i++)
            {
                int pointerLoc = 0xfff9e + i * 2;
                romFile.Seek(pointerLoc, SeekOrigin.Begin);
                int offset = romFile.ReadByte() | (romFile.ReadByte() << 8);

                int loc = 0xffc00 + offset;
                romFile.Seek(loc, SeekOrigin.Begin);
                string line = table.GetLine(romFile, loc);
                //Console.WriteLine(line);
                ff6TBlitzDescriptions[i] = line;
            }
            romFile.Close();
        }


        static void DumpFF6TEditionBlueMagicDescriptions(string romName)
        {
            FF6TableReader_Script table = new FF6TableReader_Script("ff6t-script-table.txt");
            Console.OutputEncoding = System.Text.Encoding.UTF8;
            FileStream romFile = new FileStream(romName, FileMode.Open);

            for (int i = 0; i < 24; i++)
            {
                int pointerLoc = 0xfff3e + i * 2;
                romFile.Seek(pointerLoc, SeekOrigin.Begin);
                int offset = romFile.ReadByte() | (romFile.ReadByte() << 8);

                int loc = 0x2dfd90 + offset;
                romFile.Seek(loc, SeekOrigin.Begin);
                string line = table.GetLine(romFile, loc);
                //Console.WriteLine(line);
                ff6TBlueMagicDescriptions[i] = line;
            }
            romFile.Close();
        }

        static void DumpFF6TEditionJobNames(string romName)
        {
            //string romName = "ff6t.smc";
            FF6TableReader_Battle table = new FF6TableReader_Battle("ff6t-battle-table.txt");
            Console.OutputEncoding = System.Text.Encoding.UTF8;
            FileStream romFile = new FileStream(romName, FileMode.Open);

            for (int j = 0; j < 94; j++)
            {
                int loc = 0x403b40+ j * 7;
                romFile.Seek(loc, SeekOrigin.Begin);
                string line = "";

                line = table.GetLine(romFile, loc, 7, true);

                //Console.WriteLine(line);
                ff6TJobNames[j] = line;

                //Console.WriteLine("----" + loc.ToString("X6") + "\n" + line);
            }

            romFile.Close();
        }


        static void DumpFF6TEditionSongNames(string romName)
        {
            FF6TableReader_Script table = new FF6TableReader_Script("ff6t-menu-table.txt");
            Console.OutputEncoding = System.Text.Encoding.UTF8;
            FileStream romFile = new FileStream(romName, FileMode.Open);

            for (int i = 0; i < 254; i++)
            {
                int pointerLoc = 0xe1000 + i * 2;
                romFile.Seek(pointerLoc, SeekOrigin.Begin);
                int offset = romFile.ReadByte() | (romFile.ReadByte() << 8);

                int loc = 0xe0000 + offset;
                romFile.Seek(loc, SeekOrigin.Begin);
                string line = table.GetLine(romFile, loc);

                line = line.Replace("[FF]", " ");
                ff6TSongNames[i] = line;

                //Console.WriteLine(line);
            }

            romFile.Close();
        }


        static void DumpFF6TEditionStatusEffects(string romName)
        {
            FF6TableReader_Item table = new FF6TableReader_Item("ff6t-item-table.txt");
            Console.OutputEncoding = System.Text.Encoding.UTF8;
            FileStream romFile = new FileStream(romName, FileMode.Open);

            for (int i = 0; i < 32; i++)
            {
                int loc = 0x2ade1 + i * 7;
                romFile.Seek(loc, SeekOrigin.Begin);
                string line = table.GetLine(romFile, loc, 7);
                ff6TStatusEffects[i] = line;

                //Console.WriteLine(line);
            }
            romFile.Close();
        }

    }

    //========================================================================================/
    //========================================================================================/

    public class TableReader
    {
        Hashtable htoeEntries;
        Hashtable etohEntries;
        string tableFilename;

        int maxLineWidth = 10;
        public bool convertToHTML = true;
        public bool showAllCodes = false;

        public TableReader()
        {
        }

        public TableReader(string filename)
        {
            LoadTextTable(filename);
        }

        public void LoadTextTable(string filename)
        {
            tableFilename = filename;
            string[] tableLines = System.IO.File.ReadAllLines(tableFilename);
            string[] pieces;

            htoeEntries = new Hashtable();
            etohEntries = new Hashtable();
            foreach (string str in tableLines)
            {
                pieces = str.Split(new Char[] { '=' });

                htoeEntries[pieces[0]] = pieces[1];
                etohEntries[pieces[1]] = pieces[0];
            }
        }

        public string HexToEntry(int hex)
        {
            string temp = String.Format("{0:X}", hex);
            if (hex < 0x10)
            {
                temp = hex.ToString("X2");
            }

            if (htoeEntries[temp] != null)
                return (string)htoeEntries[temp];
            else
                return null;
        }

        public int EntryToHex(string entry)
        {
            string temp = (string)etohEntries[entry];
            if (etohEntries[entry] != null)
            {
                return Int32.Parse((string)etohEntries[entry], System.Globalization.NumberStyles.HexNumber);
            }
            else
                return -1;
        }

        public bool IsPunctuation(string lastChar)
        {
            bool retVal = false;

            if (lastChar == "." || lastChar == "。" || lastChar == "!" || lastChar == "?" || lastChar == "‥" || lastChar == "…" || lastChar == "」"
             || lastChar == "』")
            {
                retVal = true;
            }

            return retVal;
        }

        public bool isSentenceEnder(string lastChar)
        {
            if (lastChar == "！" || lastChar == "〉" || lastChar == "♪" || lastChar == "["
                        || lastChar == "]" || lastChar == "(" || lastChar == ")" || lastChar == "・" || lastChar == "‥"
                        || lastChar == "：" || lastChar == "－" || lastChar == "＆" || lastChar == "／" || lastChar == "～"
                        || lastChar == "「" || lastChar == "」" ||
                        lastChar == "『" || lastChar == "』" || lastChar == "？" || lastChar == "☆" || lastChar == "。"
                        || lastChar == "♥"
                )
            {
                return true;
            }
            else
            {
                return false;
            }
        }

        public virtual string GetLine(FileStream f, int loc, int maxLength = 5000, bool isBattle = false, bool alternateCodes = false)
        {
            string str = "";
            int ch = 0;
            int count = 0;
            int charCount = 0;
            int lastCh = 0;

            f.Seek(loc, SeekOrigin.Begin);
            ch = f.ReadByte();
            count++;
            while (ch != 0x00 && count <= maxLength)
            {
                if (ch == 0x00) // end of line, wait for input
                {
                    break;
                }
                else
                {
                    string s = HexToEntry((int)ch);

                    if (s != null)
                    {
                        str += s;
                    }
                    else
                    {
                        str += "[" + ch.ToString("X2") + "]";
                    }

                    charCount++;
                }

                lastCh = ch;

                ch = f.ReadByte();
                count++;
            }

            return str;
        }
    }

















    //========================================================================================/
    //========================================================================================/

    class FF3TableReader_Script : TableReader
    {
        public FF3TableReader_Script(string filename)
        {
            LoadTextTable(filename);
        }

        public virtual string GetLine(FileStream f, int loc, int maxLength = 5000, bool isBattle = false, bool alternateCodes = false)
        {
            string str = "";
            int ch = 0;
            int count = 0;
            int charCount = 0;
            int lastCh = 0;

            f.Seek(loc, SeekOrigin.Begin);
            ch = f.ReadByte();
            count++;
            while (ch != 0x00 && count <= maxLength)
            {
                if (ch == 0x00) // end of line
                {
                    break;
                }
                else if (ch == 0x01) // newline
                {
                    if (showAllCodes)
                    {
                        str += (convertToHTML) ? "<br />" : "[NEWLINE]";
                    }
                    else
                    {
                        str += (convertToHTML) ? "<br />" : "\n";
                    }
                }
                else if (ch == 0x10 || ch == 0x11 || ch == 0x12) // pause codes, 0x10 pauses for 60 frames, 0x12 pauses for 1, 0x11 uses a parameter
                {
                    int duration = 0;
                    if (ch == 0x10)
                    {
                        duration = 60;
                    }
                    else if (ch == 0x12)
                    { 
                        duration = 1; 
                    }
                    else if (ch == 0x11)
                    {
                        duration = f.ReadByte() * 15;
                        count++;
                    }

                    if (showAllCodes)
                    {
                        str += "[PAUSE_" + duration.ToString() + "]";
                    }
                }
                else if (ch == 0x13) // new page
                {
                    if (showAllCodes)
                    {
                        str += (convertToHTML) ? "<hr class=\"newpage\" />" : "[NEWPAGE]";
                    }
                    else
                    {
                        str += (convertToHTML) ? "<hr class=\"newpage\" />" : "\n\n";
                    }
                }
                else if (ch == 0x14) // blank space padding; parameter byte is the # of spaces to write
                {
                    int param1 = f.ReadByte();
                    count++;

                    for (int i = 0; i < param1; i++)
                    {
                        if (showAllCodes)
                        {
                            str += (convertToHTML) ? "&nbsp;" : " ";
                        }
                    }
                }
                else if (ch == 0x15) // choice given
                {
                    if (showAllCodes)
                    {
                        str += (convertToHTML) ? "<div class=\"choice\"></div>" : "[CHOICE]";
                    }
                }
                else if (ch == 0x16) // wait for key input for XX * 15 frames
                {
                    int duration = f.ReadByte() * 15;
                    count++;

                    if (showAllCodes)
                    {
                        str += "[WAIT_" + duration.ToString() + "]";
                    }
                }
                else if (ch == 0x19) // GP
                {
                    str += (convertToHTML) ? "<div class=\"money\">GP</div>" : "[GP]";
                }
                else if (ch == 0x1A) // Item
                {
                    str += (convertToHTML) ? "<div class=\"item\">Item</div>" : "[ITEM]";
                }
                else if (ch == 0x1B) // Skill
                {
                    str += (convertToHTML) ? "<div class=\"skill\">Skill</div>" : "[SKILL]";
                }
                else
                {
                    string s = HexToEntry((int)ch);

                    if (s != null)
                    {
                        str += s;
                    }
                    else
                    {
                        str += "[" + ch.ToString("X2") + "]";
                    }

                    charCount++;
                }

                lastCh = ch;

                ch = f.ReadByte();
                count++;

            }

            return str;
        }
    }




    //========================================================================================/
    //========================================================================================/

    class FanTableReader_Script : TableReader
    {
        public FanTableReader_Script(string filename)
        {
            LoadTextTable(filename);
        }

        public virtual string GetLine(FileStream f, int loc, int maxLength = 5000, bool isBattle = false, bool alternateCodes = false)
        {
            string str = "";
            int ch = 0;
            int count = 0;
            int charCount = 0;
            int lastCh = 0;

            f.Seek(loc, SeekOrigin.Begin);
            ch = f.ReadByte();
            count++;
            while (ch != 0x00 && count <= maxLength)
            {
                if (ch == 0x00) // end of line
                {
                    break;
                }
                else if (ch == 0x01) // newline
                {
                    if (showAllCodes)
                    {
                        str += (convertToHTML) ? "<br />" : "[NEWLINE]";
                    }
                    else
                    {
                        str += (convertToHTML) ? "<br />" : "\n";
                    }
                }
                else if (alternateCodes && ch == 0x02)
                {
                    int argument = f.ReadByte();
                    str += "_CHAR" + argument.ToString() + "_";

                    count++;
                }
                else if (ch == 0x10 || ch == 0x11 || ch == 0x12) // pause codes, 0x10 pauses for 60 frames, 0x12 pauses for 1, 0x11 uses a parameter
                {
                    int duration = 0;
                    if (ch == 0x10)
                    {
                        duration = 60;
                    }
                    else if (ch == 0x12)
                    {
                        duration = 1;
                    }
                    else if (ch == 0x11)
                    {
                        duration = f.ReadByte() * 15;
                        count++;
                    }

                    if (showAllCodes)
                    {
                        str += "[PAUSE_" + duration.ToString() + "]";
                    }
                }
                else if (ch == 0x13) // new page
                {
                    if (showAllCodes)
                    {
                        str += (convertToHTML) ? "<hr class=\"newpage\" />" : "[NEWPAGE]";
                    }
                    else
                    {
                        str += (convertToHTML) ? "<hr class=\"newpage\" />" : "\n\n";
                    }
                }
                else if (ch == 0x14) // blank space padding; parameter byte is the # of spaces to write
                {
                    int param1 = f.ReadByte();
                    count++;

                    for (int i = 0; i < param1; i++)
                    {
                        if (showAllCodes)
                        {
                            str += (convertToHTML) ? "&nbsp;" : " ";
                        }
                    }
                }
                else if (ch == 0x15) // choice given
                {
                    if (showAllCodes)
                    {
                        str += (convertToHTML) ? "<div class=\"choice\"></div>" : "[CHOICE]";
                    }
                }
                else if (ch == 0x16) // wait for key input for XX * 15 frames
                {
                    int duration = f.ReadByte() * 15;
                    count++;

                    if (showAllCodes)
                    {
                        str += "[WAIT_" + duration.ToString() + "]";
                    }
                }
                else if (ch == 0x1F) // not 100% sure what this is
                {
                    int argument = f.ReadByte();
                    count++;

                    if (showAllCodes)
                    {
                        str += "[1F_" + argument.ToString() + "]";
                    }
                }
                else if (ch == 0x19) // GP
                {
                    str += (convertToHTML) ? "<div class=\"money\">GP</div>" : "[GP]";
                }
                else if (ch == 0x1A) // Item
                {
                    str += (convertToHTML) ? "<div class=\"item\">Item</div>" : "[ITEM]";
                }
                else if (ch == 0x1B) // Skill
                {
                    str += (convertToHTML) ? "<div class=\"skill\">Skill</div>" : "[SKILL]";
                }
                else
                {
                    string s = HexToEntry((int)ch);

                    if (s != null)
                    {
                        str += s;
                    }
                    else
                    {
                        str += "[" + ch.ToString("X2") + "]";
                    }

                    charCount++;
                }

                lastCh = ch;

                ch = f.ReadByte();
                count++;

            }

            return str;
        }
    }



    //========================================================================================/
    //========================================================================================/


    // NEED TO UPDATE THE GBA TABLE TO MATCH WHAT'S EXPECTED IN OUR SFC TABLE
    // ALSO NEED TO ADD MORE CONTROL CODES TO GETLINE HERE!!!



    class GBATableReader_Script : TableReader
    {
        public GBATableReader_Script(string filename)
        {
            LoadTextTable(filename);
        }

        public virtual string GetLine(FileStream f, int loc, int maxLength = 5000, bool isBattle = false, bool alternateCodes = false)
        {
            string str = "";
            int ch = 0;
            int count = 0;
            int charCount = 0;
            int lastCh = 0;

            f.Seek(loc, SeekOrigin.Begin);
            ch = f.ReadByte();
            count++;
            while (ch != 0x0e && count <= maxLength)
            {
                if (ch == 0x0e) // end of line
                {
                    break;
                }
                else if (ch >= 0xC0 && ch <= 0xCF)
                {
                    int argument = f.ReadByte();
                    count++;

                    string tableEntry = HexToEntry((ch << 8) + argument);
                    if (tableEntry != null)
                    {
                        str += tableEntry;
                    }
                    /*else if (ch == 0xC5)
                    {
                        // we'll skip C5 codes as they're mostly pauses and formatting related
                    }*/
                    else if (ch == 0xC4 && argument == 0x8E) // newline
                    {
                        if (showAllCodes)
                        {
                            str += (convertToHTML) ? "<br />" : "\n";
                        }
                        else
                        {
                            str += (convertToHTML) ? "<br />" : "\n";
                        }
                    }
                    else if (ch == 0xC4 && (argument == 0xBE || argument == 0xB8)) // new window
                    {
                        if (showAllCodes)
                        {
                            str += (convertToHTML) ? "<hr class=\"newpage\" />" : "\n[NEWPAGE]\n";
                        }
                        else
                        {
                            str += (convertToHTML) ? "<hr class=\"newpage\" />" : "\n\n";
                        }
                    }
                    else if (ch == 0xC4 && argument == 0xBA) // wait command
                    {
                        if (isBattle)
                        {
                            str += "[WAIT]";
                        }
                        else
                        {
                            int duration = (f.ReadByte() << 8) + f.ReadByte();
                            duration -= 0xC585;
                            duration = (duration * 5) + 15;
                            duration = duration / 3;

                            str += "[WAIT_" + duration.ToString("X2") + "]";
                        }

                        
                    }
                    else if (ch >= 0xC5 && ch <= 0xC9)
                    {
                        int temp = (ch << 8) + argument;
                        temp -= 0xC585;
                        temp = (temp * 5) + 15;
                        temp = temp / 15;
                        str += "[PAUSE_" + temp.ToString("X2") + "]";

                        //int temp = argument;
                        //str += "[" + ch.ToString("X2") + "][" + argument.ToString("X2") + "]";
                    }
                    else
                    {
                        str += "[" + ch.ToString("X2") + "][" + argument.ToString("X2") + "]";
                    }
                }
                else
                {
                    string s = HexToEntry((int)ch);

                    if (s != null)
                    {
                        str += s;
                    }
                    else
                    {
                        str += "[" + ch.ToString("X2") + "]";
                    }

                    charCount++;
                }

                lastCh = ch;

                ch = f.ReadByte();
                count++;

            }

            str = str.Trim();

            str = str.Replace("\n\n", "\n[NEWPAGE]\n"); // gba has three lines of text per window, snes uses 4, so we do this to sort of compensate
            str = str.Replace("\n\n", "\n");

            //str += "\n--------------------";

            return str;
        }
    }


    //========================================================================================/
    //========================================================================================/

    class GBAItemTableReader_Script : TableReader
    {
        public GBAItemTableReader_Script(string filename)
        {
            LoadTextTable(filename);
        }

        public virtual string GetLine(FileStream f, int loc, int maxLength = 5000, bool isBattle = false, bool alternateCodes = false)
        {
            string str = "";
            int ch = 0;
            int count = 0;
            int charCount = 0;
            int lastCh = 0;

            f.Seek(loc, SeekOrigin.Begin);
            ch = f.ReadByte();
            count++;
            while (ch != 0x04 && count <= maxLength)
            {
                if (ch == 0x04) // end of line
                {
                    break;
                }
                else if (ch == 0xC2)
                {
                    int argument = f.ReadByte();
                    count++;

                    if (argument == 0x9D)
                    {
                        if (showAllCodes)
                        {
                            str += "[C2][9D]";
                        }
                        else
                        {
                            str += (convertToHTML) ? "<br />" : "[C2][9D]";
                        }
                    }
                }
                else
                {
                    string s = HexToEntry((int)ch);

                    if (s != null)
                    {
                        str += s;
                    }
                    else
                    {
                        str += "[" + ch.ToString("X2") + "]";
                    }

                    charCount++;
                }

                lastCh = ch;

                ch = f.ReadByte();
                count++;

            }

            //str = str.Replace("\n\n", "\n[NEWPAGE]\n"); // gba has three lines of text per window, snes uses 4, so we do this to sort of compensate
            //str = str.Replace("\n\n", "\n");

            //str += "\n--------------------";

            return str;
        }
    }



    //========================================================================================/
    //========================================================================================/

    class FF6TableReader_Script : TableReader
    {
        public FF6TableReader_Script(string filename)
        {
            LoadTextTable(filename);
        }

        public virtual string GetLine(FileStream f, int loc, int maxLength = 5000, bool isBattle = false, bool alternateCodes = false)
        {
            string str = "";
            int ch = 0;
            int count = 0;
            int charCount = 0;
            int lastCh = 0;

            showAllCodes = true;
            convertToHTML = false;

            f.Seek(loc, SeekOrigin.Begin);
            ch = f.ReadByte();
            count++;
            while (ch != 0x00 && count <= maxLength)
            {
                if (ch == 0x00) // end of line
                {
                    break;
                }
                else if (ch == 0x01) // newline
                {
                    if (alternateCodes)
                    {
                        str += "[01]";
                    }
                    else
                    {
                        if (showAllCodes)
                        {
                            str += (convertToHTML) ? "<br />" : "\n";
                        }
                        else
                        {
                            str += (convertToHTML) ? "<br />" : "\n";
                        }
                    }
                }
                else if (ch == 0x02 && isBattle)
                {
                    int param = f.ReadByte();
                    count++;
                    string z = HexToEntry((ch << 8) + param);
                    str += z;
                }
                else if (ch == 0x10)
                {
                    if (showAllCodes)
                    {
                        str += "[LONGPAUSE]";
                    }
                }
                else if (ch == 0x12) // pause codes, 0x10 pauses for 60 frames, 0x12 pauses for 1, 0x11 uses a parameter
                {
                    if (showAllCodes)
                    {
                        str += "[SHORTPAUSE]";
                    }
                }
                else if (ch == 0x11)
                {
                    int duration = f.ReadByte(); // *15;
                    count++;
                    str += "[PAUSE_" + duration.ToString("X2") + "]";
                }
                else if (ch == 0x13) // new page
                {
                    if (showAllCodes)
                    {
                        str += (convertToHTML) ? "<hr class=\"newpage\" />" : "\n[NEWPAGE]\n";
                    }
                    else
                    {
                        str += (convertToHTML) ? "<hr class=\"newpage\" />" : "\n\n";
                    }
                }
                else if (ch == 0x14) // blank space padding; parameter byte is the # of spaces to write
                {
                    int param1 = f.ReadByte();
                    count++;

                    str += (convertToHTML) ? "&nbsp;" : "[SPACE_" + param1.ToString("X2") + "]";

                    /*for (int i = 0; i < param1; i++)
                    {
                        if (showAllCodes)
                        {
                            str += (convertToHTML) ? "&nbsp;" : " ";
                        }
                    }*/
                }
                else if (ch == 0x15) // choice given
                {
                    if (showAllCodes)
                    {
                        str += (convertToHTML) ? "<div class=\"choice\"></div>" : "[CHOICE]";
                    }
                }
                else if (ch == 0x16) // wait for key input for XX * 15 frames
                {
                    int duration = f.ReadByte();// *15;
                    count++;

                    if (showAllCodes)
                    {
                        str += "[WAIT_" + duration.ToString("X2") + "]";
                    }
                }
                else if (ch == 0x19) // GP
                {
                    str += (convertToHTML) ? "<div class=\"money\">GP</div>" : "[GP]";
                }
                else if (ch == 0x1A) // Item
                {
                    str += (convertToHTML) ? "<div class=\"item\">Item</div>" : "[ITEM]";
                }
                /*else if (ch == 0x1B) // Skill
                {
                    str += (convertToHTML) ? "<div class=\"skill\">Skill</div>" : "[SKILL]";
                }*/
                else if (ch == 0x17 || ch == 0x18 || ch == 0x1B || ch == 0x1C || ch == 0x1D || ch == 0x1E || ch == 0x1F) // kanji code, following byte specifies a certain kanji
                {
                    int param = f.ReadByte();
                    count++;
                    str += HexToEntry((ch << 8) + param);
                }
                else
                {
                    string s = HexToEntry((int)ch);

                    if (s != null)
                    {
                        str += s;
                    }
                    else
                    {
                        str += "[" + ch.ToString("X2") + "]";
                    }

                    charCount++;
                }

                lastCh = ch;

                ch = f.ReadByte();
                count++;

            }

            str += "\n--------------------";
            //str += "\n[END]";

            //return str.Trim();
            return str;
        }
    }

    //========================================================================================/
    //========================================================================================/

    class FF6TableReader_Item : TableReader
    {
        public FF6TableReader_Item(string filename)
        {
            LoadTextTable(filename);
        }

        public virtual string GetLine(FileStream f, int loc, int maxLength = 9)
        {
            string str = "";
            int ch = 0;
            int count = 0;
            int charCount = 0;
            int lastCh = 0;

            showAllCodes = true;
            convertToHTML = false;

            f.Seek(loc, SeekOrigin.Begin);
            ch = f.ReadByte();
            count++;
            while (ch != 0xFF && count <= maxLength)
            {
                if (ch == 0xFF) // end of line
                {
                    break;
                }
                else
                {
                    string s = HexToEntry((int)ch);

                    if (s != null)
                    {
                        str += s;
                    }
                    else
                    {
                        str += "[" + ch.ToString("X2") + "]";
                    }

                    charCount++;
                }

                lastCh = ch;

                ch = f.ReadByte();
                count++;

            }

            //str += "\n--------------------";
            //str += "\n[END]";


            //return str.Trim();
            return str;
        }
    }

    //========================================================================================/
    //========================================================================================/

    class FF6TableReader_Battle : TableReader
    {
        public FF6TableReader_Battle(string filename)
        {
            LoadTextTable(filename);
        }

        public virtual string GetLine(FileStream f, int loc, int maxLength = 5000, bool displayAllOnOneLine = false, bool stopOnFF = false)
        {
            string str = "";
            int ch = 0;
            int count = 0;
            int charCount = 0;
            int lastCh = 0;

            showAllCodes = true;
            convertToHTML = false;

            f.Seek(loc, SeekOrigin.Begin);
            ch = f.ReadByte();
            count++;
            while (ch != 0x00 && count <= maxLength)// && ch != 0xFF && count <= maxLength)
            {
                if (stopOnFF && ch == 0xFF)
                {
                    break;
                }

                if (ch == 0x00) // end of line
                {
                    break;
                }
                else if (ch == 0x01) // newline
                {
                    if (displayAllOnOneLine)
                    {
                        str += "[01]";
                    }
                    else
                    {
                        str += "\n";
                    }
                }
                else if (ch == 0x02) // character's name
                {
                    int param = f.ReadByte();
                    count++;
                    string z = HexToEntry((ch << 8) + param);
                    str += z;
                }
                else if (ch == 0x04) // color toggle (red font?)
                {
                    str += "[COLOR]";
                }
                else if (ch == 0x05) // pauses for 60 frames
                {
                    str += "[SHORTPAUSE]";
                }
                else if (ch == 0x06) // pauses for 146 frames
                {
                    str += "[LONGPAUSE]";
                }
                else if (ch == 0x07) // waits for key press
                {
                    str += "[WAIT]";
                }
                
                // 0x10 is [VAR1] and 0x11 is [VAR2] but we'll just leave these codes in naked hex

                else if (ch == 0x12)
                {
                    int type = f.ReadByte();
                    count++;

                    if (type == 0)
                    {
                        str += "[ACTOR]";
                    }
                    else if (type == 1)
                    {
                        str += "[ITEM]";
                    }
                    else if (type == 2)
                    {
                        str += "[SKILL]";
                    }
                    else if (type == 3)
                    {
                        str += "[COMMAND]";
                    }
                    else
                    {
                        str = str + "[12][" + type.ToString("X2") + "]";
                    }

                    // 0x13 is [VAR3] and 0x14 is [VAR4] but we'll just leave these codes in naked hex
                }

                //else if (ch == 0x1C || ch == 0x1D || ch == 0x1E || ch == 0x1F) // kanji code, following byte specifies a certain kanji
                else if (ch == 0x17 || ch == 0x18 || ch == 0x1B || ch == 0x1C || ch == 0x1D || ch == 0x1E || ch == 0x1F) // kanji code, following byte specifies a certain kanji
                {
                    int param = f.ReadByte();
                    count++;
                    str += HexToEntry((ch << 8) + param);
                }
                else
                {
                    string s = HexToEntry((int)ch);

                    if (s != null)
                    {
                        str += s;
                    }
                    else
                    {
                        str += "[" + ch.ToString("X2") + "]";
                    }

                    charCount++;
                }

                lastCh = ch;

                ch = f.ReadByte();
                count++;

            }

            str += "\n--------------------";
            //str += "\n[END]";


            //return str.Trim();
            return str;
        }
    }






    //========================================================================================/
    //========================================================================================/

    class FF6TEditionTableReader_Script : TableReader
    {
        public FF6TEditionTableReader_Script(string filename)
        {
            LoadTextTable(filename);
        }

        public virtual string GetLine(FileStream f, int loc, int maxLength = 5000, bool isBattle = false, bool alternateCodes = false)
        {
            string str = "";
            int ch = 0;
            int count = 0;
            int charCount = 0;
            int lastCh = 0;

            showAllCodes = true;
            convertToHTML = false;

            f.Seek(loc, SeekOrigin.Begin);
            ch = f.ReadByte();
            count++;
            while (ch != 0x00 && count <= maxLength)
            {
                if (ch == 0x00) // end of line
                {
                    break;
                }
                else if (ch == 0x01) // newline
                {
                    if (showAllCodes)
                    {
                        str += (convertToHTML) ? "<br />" : "\n";
                    }
                    else
                    {
                        str += (convertToHTML) ? "<br />" : "\n";
                    }
                }
                else if (ch == 0x10)
                {
                    if (showAllCodes)
                    {
                        str += "[LONGPAUSE]";
                    }
                }
                else if (ch == 0x12) // pause codes, 0x10 pauses for 60 frames, 0x12 pauses for 1, 0x11 uses a parameter
                {
                    if (showAllCodes)
                    {
                        str += "[SHORTPAUSE]";
                    }
                }
                else if (ch == 0x11)
                {
                    int duration = f.ReadByte(); // *15;
                    count++;
                    str += "[PAUSE_" + duration.ToString("X2") + "]";
                }
                else if (ch == 0x13) // new page
                {
                    if (showAllCodes)
                    {
                        str += (convertToHTML) ? "<hr class=\"newpage\" />" : "\n[NEWPAGE]\n";
                    }
                    else
                    {
                        str += (convertToHTML) ? "<hr class=\"newpage\" />" : "\n\n";
                    }
                }
                else if (ch == 0x14) // blank space padding; parameter byte is the # of spaces to write
                {
                    int param1 = f.ReadByte();
                    count++;

                    str += (convertToHTML) ? "&nbsp;" : "[SPACE_" + param1.ToString("X2") + "]";

                    /*for (int i = 0; i < param1; i++)
                    {
                        if (showAllCodes)
                        {
                            str += (convertToHTML) ? "&nbsp;" : " ";
                        }
                    }*/
                }
                else if (ch == 0x15) // choice given
                {
                    if (showAllCodes)
                    {
                        str += (convertToHTML) ? "<div class=\"choice\"></div>" : "[CHOICE]";
                    }
                }
                else if (ch == 0x16) // wait for key input for XX * 15 frames
                {
                    int duration = f.ReadByte();// *15;
                    count++;

                    if (showAllCodes)
                    {
                        str += "[WAIT_" + duration.ToString("X2") + "]";
                    }
                }
                else if (ch == 0x19) // GP
                {
                    str += (convertToHTML) ? "<div class=\"money\">GP</div>" : "[GP]";
                }
                else if (ch == 0x1A) // Item
                {
                    str += (convertToHTML) ? "<div class=\"item\">Item</div>" : "[ITEM]";
                }
                /*else if (ch == 0x1B) // Skill
                {
                    str += (convertToHTML) ? "<div class=\"skill\">Skill</div>" : "[SKILL]";
                }*/
                else if (ch == 0x17 || ch == 0x18 || ch == 0x1B || ch == 0x1C || ch == 0x1D || ch == 0x1E || ch == 0x1F) // kanji code, following byte specifies a certain kanji
                {
                    int param = f.ReadByte();
                    count++;
                    str += HexToEntry((ch << 8) + param);
                }
                else
                {
                    string s = HexToEntry((int)ch);

                    if (s != null)
                    {
                        str += s;
                    }
                    else
                    {
                        str += "[" + ch.ToString("X2") + "]";
                    }

                    charCount++;
                }

                lastCh = ch;

                ch = f.ReadByte();
                count++;

            }

            if (str == "")
            {
                str = "BLANK LINE: 0x" + loc.ToString("X6");
            }

            //str += "\n--------------------";
            //str += "[END]";


            return str.Trim();
        }
    }

}
